/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClassFabUtils;

public class ClassFactoryClassPool
extends ClassPool {
    private static final Method defineClass = ClassFactoryClassPool.findMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
    private static final Method defineClassWithProtectionDomain = ClassFactoryClassPool.findMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
    private final Set<ClassLoader> allLoaders = CollectionFactory.newSet();
    private final Map<ClassLoader, ClassPath> leafLoaders = CollectionFactory.newMap();

    private static Method findMethod(final String methodName, final Class ... parameterTypes) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public Method run() throws Exception {
                    Class<?> cl = Class.forName("java.lang.ClassLoader");
                    Method result = cl.getDeclaredMethod(methodName, parameterTypes);
                    result.setAccessible(true);
                    return result;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw new RuntimeException(String.format("Unable to initialize ClassFactoryClassPool: %s", InternalUtils.toMessage(ex)), ex);
        }
    }

    public ClassFactoryClassPool(ClassLoader contextClassLoader) {
        super(null);
        this.addClassLoaderIfNeeded(contextClassLoader);
    }

    public Class importClass(Class clazz) {
        this.addClassLoaderIfNeeded(clazz.getClassLoader());
        while (true) {
            try {
                String name = ClassFabUtils.toJavaClassName(clazz);
                this.get(name);
            }
            catch (NotFoundException ex) {
                clazz = clazz.getSuperclass();
                continue;
            }
            break;
        }
        return clazz;
    }

    public synchronized void addClassLoaderIfNeeded(ClassLoader loader) {
        ClassLoader existingLeaf;
        Set<ClassLoader> leaves = this.leafLoaders.keySet();
        if (loader == null || leaves.contains(loader) || this.allLoaders.contains(loader)) {
            return;
        }
        for (existingLeaf = loader; existingLeaf != null && !leaves.contains(existingLeaf); existingLeaf = existingLeaf.getParent()) {
        }
        if (existingLeaf != null) {
            ClassPath priorPath = this.leafLoaders.get(existingLeaf);
            this.removeClassPath(priorPath);
            this.leafLoaders.remove(existingLeaf);
        }
        LoaderClassPath path = new LoaderClassPath(loader);
        this.leafLoaders.put(loader, (ClassPath)path);
        this.insertClassPath((ClassPath)path);
        for (ClassLoader l = loader; l != null; l = l.getParent()) {
            this.allLoaders.add(l);
        }
    }

    public Class toClass(CtClass ct, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        Throwable failure;
        try {
            Object[] objectArray;
            Method method;
            byte[] b = ct.toBytecode();
            boolean hasDomain = domain != null;
            Method method2 = method = hasDomain ? defineClassWithProtectionDomain : defineClass;
            if (hasDomain) {
                Object[] objectArray2 = new Object[5];
                objectArray2[0] = ct.getName();
                objectArray2[1] = b;
                objectArray2[2] = 0;
                objectArray2[3] = b.length;
                objectArray = objectArray2;
                objectArray2[4] = domain;
            } else {
                Object[] objectArray3 = new Object[4];
                objectArray3[0] = ct.getName();
                objectArray3[1] = b;
                objectArray3[2] = 0;
                objectArray = objectArray3;
                objectArray3[3] = b.length;
            }
            Object[] args = objectArray;
            return (Class)method.invoke((Object)loader, args);
        }
        catch (InvocationTargetException ite) {
            failure = ite.getTargetException();
        }
        catch (Exception ex) {
            failure = ex;
        }
        throw new CannotCompileException(String.format("Failure defining new class %s: %s", ct.getName(), InternalUtils.toMessage(failure)), failure);
    }
}

