/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.test;

import java.util.Arrays;
import java.util.List;
import org.apache.tapestry.ioc.test.MockTester;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.easymock.IMocksControl;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestBase
extends Assert {
    private final MockTester _tester = new MockTester();

    protected final IMocksControl getMocksControl() {
        return this._tester.getMocksControl();
    }

    @AfterMethod(alwaysRun=true)
    public final void discardMockControl() {
        this._tester.cleanup();
    }

    protected final <T> T newMock(Class<T> mockClass) {
        return this._tester.newMock(mockClass);
    }

    protected final void replay() {
        this._tester.replay();
    }

    protected final void verify() {
        this._tester.verify();
    }

    protected final void setThrowable(Throwable throwable) {
        EasyMock.expectLastCall().andThrow(throwable);
    }

    protected final void unreachable() {
        TestBase.fail((String)"This code should not be reachable.");
    }

    protected final <T> IExpectationSetters<T> expect(T value) {
        return EasyMock.expect(value);
    }

    protected final void assertMessageContains(Throwable t, String ... substrings) {
        String message = t.getMessage();
        for (String substring : substrings) {
            TestBase.assertTrue((boolean)message.contains(substring), (String)String.format("String '%s' not found in '%s'.", substring, message));
        }
    }

    protected final <T> void assertListsEquals(List<T> actual, List<T> expected) {
        int count = Math.min(actual.size(), expected.size());
        for (int i = 0; i < count; ++i) {
            TestBase.assertEquals(actual.get(i), expected.get(i), (String)String.format("Element #%d.", i));
        }
        TestBase.assertEquals((int)actual.size(), (int)expected.size(), (String)"List size.");
    }

    protected final <T> void assertListsEquals(List<T> actual, T ... expected) {
        this.assertListsEquals(actual, Arrays.asList(expected));
    }

    protected final <T> void assertArraysEqual(T[] actual, T ... expected) {
        this.assertListsEquals(Arrays.asList(actual), expected);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalControl
    extends ThreadLocal<IMocksControl> {
        private ThreadLocalControl() {
        }

        @Override
        protected IMocksControl initialValue() {
            return EasyMock.createControl();
        }
    }
}

