/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.util;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.tapestry.ioc.AnnotationProvider;
import org.apache.tapestry.ioc.Locatable;
import org.apache.tapestry.ioc.Location;
import org.apache.tapestry.ioc.ObjectLocator;
import org.apache.tapestry.ioc.annotations.Inject;
import org.apache.tapestry.ioc.annotations.InjectService;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.UtilMessages;
import org.apache.tapestry.ioc.services.ClassFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalUtils {
    private static final String NAME_PREFIX = "_$";

    public static String asString(Method method, ClassFactory classFactory) {
        Location location = classFactory.getMethodLocation(method);
        return location != null ? location.toString() : InternalUtils.asString(method);
    }

    public static String asString(Method method) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(method.getDeclaringClass().getName());
        buffer.append(".");
        buffer.append(method.getName());
        buffer.append("(");
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            String name = method.getParameterTypes()[i].getSimpleName();
            buffer.append(name);
        }
        return buffer.append(")").toString();
    }

    public static int size(Object[] array) {
        return array == null ? 0 : array.length;
    }

    public static String stripMemberPrefix(String memberName) {
        char ch;
        StringBuilder builder = new StringBuilder(memberName);
        while (NAME_PREFIX.indexOf(ch = builder.charAt(0)) >= 0) {
            builder.deleteCharAt(0);
        }
        return builder.toString();
    }

    public static String createMemberName(String memberName) {
        return NAME_PREFIX + InternalUtils.stripMemberPrefix(memberName);
    }

    public static List<String> toList(Enumeration e) {
        List<String> result = CollectionFactory.newList();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }

    public static <T extends Annotation> T findAnnotation(Annotation[] annotations, Class<T> annotationClass) {
        for (Annotation a : annotations) {
            if (!annotationClass.isInstance(a)) continue;
            return (T)((Annotation)annotationClass.cast(a));
        }
        return null;
    }

    private static Object calculateParameterValue(Class parameterType, final Annotation[] parameterAnnotations, ObjectLocator locator, Map<Class, Object> parameterDefaults) {
        Object result;
        AnnotationProvider provider = new AnnotationProvider(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return InternalUtils.findAnnotation(parameterAnnotations, annotationClass);
            }
        };
        InjectService is = provider.getAnnotation(InjectService.class);
        if (is != null) {
            String serviceId = is.value();
            return locator.getService(serviceId, parameterType);
        }
        if (provider.getAnnotation(Inject.class) == null && (result = parameterDefaults.get(parameterType)) != null) {
            return result;
        }
        return locator.getObject(parameterType, provider);
    }

    public static Object[] calculateParametersForMethod(Method method, ObjectLocator locator, Map<Class, Object> parameterDefaults) {
        Class[] parameterTypes = method.getParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        return InternalUtils.calculateParameters(locator, parameterDefaults, parameterTypes, annotations);
    }

    public static Object[] calculateParametersForConstructor(Constructor constructor, ObjectLocator locator, Map<Class, Object> parameterDefaults) {
        Class[] parameterTypes = constructor.getParameterTypes();
        Annotation[][] annotations = constructor.getParameterAnnotations();
        return InternalUtils.calculateParameters(locator, parameterDefaults, parameterTypes, annotations);
    }

    public static Object[] calculateParameters(ObjectLocator locator, Map<Class, Object> parameterDefaults, Class[] parameterTypes, Annotation[][] parameterAnnotations) {
        int parameterCount = parameterTypes.length;
        Object[] parameters = new Object[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            parameters[i] = InternalUtils.calculateParameterValue(parameterTypes[i], parameterAnnotations[i], locator, parameterDefaults);
        }
        return parameters;
    }

    public static String join(List elements) {
        return InternalUtils.join(elements, ", ");
    }

    public static String join(List elements, String separator) {
        switch (elements.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return elements.get(0).toString();
            }
        }
        StringBuilder buffer = new StringBuilder();
        boolean first = true;
        for (Object o : elements) {
            String string;
            if (!first) {
                buffer.append(separator);
            }
            if ((string = String.valueOf(o)).equals("")) {
                string = "(blank)";
            }
            buffer.append(string);
            first = false;
        }
        return buffer.toString();
    }

    public static String joinSorted(Collection elements) {
        if (elements == null || elements.isEmpty()) {
            return "(none)";
        }
        List list = CollectionFactory.newList();
        for (Object o : elements) {
            list.add(String.valueOf(o));
        }
        Collections.sort(list);
        return InternalUtils.join(list);
    }

    public static boolean isBlank(String input) {
        return input == null || input.length() == 0 || input.trim().length() == 0;
    }

    public static boolean isNonBlank(String input) {
        return !InternalUtils.isBlank(input);
    }

    public static String capitalize(String input) {
        if (input.length() == 0) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static Location locationOf(Object location) {
        if (location == null) {
            return null;
        }
        if (location instanceof Location) {
            return (Location)location;
        }
        if (location instanceof Locatable) {
            return ((Locatable)location).getLocation();
        }
        return null;
    }

    public static List<String> sortedKeys(Map map) {
        if (map == null) {
            return Collections.emptyList();
        }
        List<String> keys = CollectionFactory.newList();
        for (Object o : map.keySet()) {
            keys.add(String.valueOf(o));
        }
        Collections.sort(keys);
        return keys;
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static <T> Iterator<T> reverseIterator(List<T> list) {
        final ListIterator<T> normal = list.listIterator(list.size());
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return normal.hasPrevious();
            }

            @Override
            public T next() {
                return normal.previous();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean containsSymbols(String input) {
        return input.contains("${");
    }

    public static String lastTerm(String input) {
        Defense.notBlank(input, "input");
        int dotx = input.lastIndexOf(46);
        if (dotx < 0) {
            return input;
        }
        return input.substring(dotx + 1);
    }

    public static Constructor findAutobuildConstructor(Class clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        switch (constructors.length) {
            case 1: {
                return constructors[0];
            }
            case 0: {
                return null;
            }
        }
        Comparator<Constructor> comparator = new Comparator<Constructor>(){

            @Override
            public int compare(Constructor o1, Constructor o2) {
                return o2.getParameterTypes().length - o1.getParameterTypes().length;
            }
        };
        Arrays.sort(constructors, comparator);
        return constructors[0];
    }

    public static <K, V> void addToMapList(Map<K, List<V>> map, K key, V value) {
        List<Object> list = map.get(key);
        if (list == null) {
            list = CollectionFactory.newList();
            map.put(key, list);
        }
        list.add(value);
    }

    public static void validateMarkerAnnotation(Class markerClass) {
        Retention policy = markerClass.getAnnotation(Retention.class);
        if (policy != null && policy.value() == RetentionPolicy.RUNTIME) {
            return;
        }
        throw new IllegalArgumentException(UtilMessages.badMarkerAnnotation(markerClass));
    }

    public static void validateMarkerAnnotations(Class[] markerClasses) {
        for (Class markerClass : markerClasses) {
            InternalUtils.validateMarkerAnnotation(markerClass);
        }
    }

    public static void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

