/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.util;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InternalUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdAllocator {
    private static final String SEPARATOR = "_";
    private final Map<String, NameGenerator> _generatorMap;
    private final String _namespace;

    public IdAllocator() {
        this("");
    }

    public IdAllocator(String namespace) {
        this(namespace, new HashMap<String, NameGenerator>());
    }

    private IdAllocator(String namespace, Map<String, NameGenerator> generatorMap) {
        this._namespace = namespace;
        this._generatorMap = generatorMap;
    }

    public List<String> getAllocatedIds() {
        return InternalUtils.sortedKeys(this._generatorMap);
    }

    public IdAllocator clone() {
        IdentityHashMap<NameGenerator, NameGenerator> transformMap = new IdentityHashMap<NameGenerator, NameGenerator>();
        for (NameGenerator original : this._generatorMap.values()) {
            NameGenerator copy = original.clone();
            transformMap.put(original, copy);
        }
        Map<String, NameGenerator> mapCopy = CollectionFactory.newMap();
        for (String key : this._generatorMap.keySet()) {
            NameGenerator original = this._generatorMap.get(key);
            NameGenerator copy = (NameGenerator)transformMap.get(original);
            mapCopy.put(key, copy);
        }
        return new IdAllocator(this._namespace, mapCopy);
    }

    public String allocateId(String name) {
        String result;
        String key = name + this._namespace;
        NameGenerator g = this._generatorMap.get(key);
        if (g == null) {
            g = new NameGenerator(key);
            result = key;
        } else {
            result = g.nextId();
        }
        while (this._generatorMap.containsKey(result)) {
            result = g.nextId();
        }
        this._generatorMap.put(result, g);
        return result;
    }

    public boolean isAllocated(String name) {
        return this._generatorMap.containsKey(name);
    }

    public void clear() {
        this._generatorMap.clear();
    }

    private static class NameGenerator
    implements Cloneable {
        private final String _baseId;
        private int _index;

        NameGenerator(String baseId) {
            this._baseId = baseId + IdAllocator.SEPARATOR;
        }

        public String nextId() {
            return this._baseId + this._index++;
        }

        public NameGenerator clone() {
            try {
                return (NameGenerator)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

