/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.util;

import java.net.URL;
import java.util.Locale;
import org.apache.tapestry.ioc.Resource;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.LocalizedNameGenerator;

public abstract class AbstractResource
implements Resource {
    private final String _path;

    protected AbstractResource(String path) {
        Defense.notNull(path, "path");
        this._path = path;
    }

    public final String getPath() {
        return this._path;
    }

    public final String getFile() {
        int slashx = this._path.lastIndexOf(47);
        return this._path.substring(slashx + 1);
    }

    public final String getFolder() {
        int slashx = this._path.lastIndexOf(47);
        return slashx < 0 ? "" : this._path.substring(0, slashx);
    }

    public final Resource forFile(String relativePath) {
        Defense.notNull(relativePath, "relativePath");
        StringBuilder builder = new StringBuilder(this.getFolder());
        for (String term : relativePath.split("/")) {
            if (term.equals("") || term.equals(".")) continue;
            if (term.equals("..")) {
                int slashx = builder.lastIndexOf("/");
                builder.setLength(slashx);
                continue;
            }
            if (builder.length() > 0) {
                builder.append("/");
            }
            builder.append(term);
        }
        return this.createResource(builder.toString());
    }

    public final Resource forLocale(Locale locale) {
        for (String path : new LocalizedNameGenerator(this._path, locale)) {
            Resource potential = this.createResource(path);
            URL url = potential.toURL();
            if (url == null) continue;
            return potential;
        }
        return null;
    }

    public final Resource withExtension(String extension) {
        Defense.notBlank(extension, "extension");
        int dotx = this._path.lastIndexOf(46);
        if (dotx < 0) {
            return this.createResource(this._path + "." + extension);
        }
        return this.createResource(this._path.substring(0, dotx + 1) + extension);
    }

    private Resource createResource(String path) {
        if (this._path.equals(path)) {
            return this;
        }
        return this.newResource(path);
    }

    protected abstract Resource newResource(String var1);
}

