/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import org.apache.tapestry.ioc.services.MethodSignature;

public class FilterMethodAnalyzer {
    private final Class _serviceInterface;

    FilterMethodAnalyzer(Class serviceInterface) {
        this._serviceInterface = serviceInterface;
    }

    public int findServiceInterfacePosition(MethodSignature ms, MethodSignature fms) {
        int i;
        Class[] serviceParameters;
        if (ms.getReturnType() != fms.getReturnType()) {
            return -1;
        }
        if (!ms.getName().equals(fms.getName())) {
            return -1;
        }
        Class[] filterParameters = fms.getParameterTypes();
        int filterParameterCount = filterParameters.length;
        if (filterParameterCount != (serviceParameters = ms.getParameterTypes()).length + 1) {
            return -1;
        }
        boolean found = false;
        int result = -1;
        for (i = 0; i < filterParameterCount; ++i) {
            if (filterParameters[i] != this._serviceInterface) continue;
            result = i;
            found = true;
            break;
        }
        if (!found) {
            return -1;
        }
        for (i = 0; i < result; ++i) {
            if (filterParameters[i] == serviceParameters[i]) continue;
            return -1;
        }
        for (i = result + 1; i < filterParameterCount; ++i) {
            if (filterParameters[i] == serviceParameters[i - 1]) continue;
            return -1;
        }
        return result;
    }
}

