/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.ioc.ServiceBuilderResources;
import org.apache.tapestry.ioc.def.ServiceDef;
import org.apache.tapestry.ioc.internal.ConstructorServiceCreator;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.apache.tapestry.ioc.internal.InternalRegistry;
import org.apache.tapestry.ioc.internal.Module;
import org.apache.tapestry.ioc.internal.ObjectLocatorImpl;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.services.ClassFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceResourcesImpl
extends ObjectLocatorImpl
implements ServiceBuilderResources {
    private final ServiceDef _serviceDef;
    private final Logger _logger;
    private final ClassFactory _classFactory;

    public ServiceResourcesImpl(InternalRegistry registry, Module module, ServiceDef serviceDef, ClassFactory classFactory, Logger logger) {
        super(registry, module);
        this._serviceDef = serviceDef;
        this._classFactory = classFactory;
        this._logger = logger;
    }

    @Override
    public String getServiceId() {
        return this._serviceDef.getServiceId();
    }

    @Override
    public Class getServiceInterface() {
        return this._serviceDef.getServiceInterface();
    }

    @Override
    public Logger getLogger() {
        return this._logger;
    }

    @Override
    public <T> Collection<T> getUnorderedConfiguration(Class<T> valueType) {
        Collection<T> result = this.getRegistry().getUnorderedConfiguration(this._serviceDef, valueType);
        this.logConfiguration(result);
        return result;
    }

    private void logConfiguration(Collection configuration) {
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(IOCMessages.constructedConfiguration(configuration));
        }
    }

    @Override
    public <T> List<T> getOrderedConfiguration(Class<T> valueType) {
        List<T> result = this.getRegistry().getOrderedConfiguration(this._serviceDef, valueType);
        this.logConfiguration(result);
        return result;
    }

    @Override
    public <K, V> Map<K, V> getMappedConfiguration(Class<K> keyType, Class<V> valueType) {
        Map<K, V> result = this.getRegistry().getMappedConfiguration(this._serviceDef, keyType, valueType);
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(IOCMessages.constructedConfiguration(result));
        }
        return result;
    }

    @Override
    public Object getModuleBuilder() {
        return this.getModule().getModuleBuilder();
    }

    @Override
    public <T> T autobuild(Class<T> clazz) {
        Defense.notNull(clazz, "clazz");
        Constructor constructor = InternalUtils.findAutobuildConstructor(clazz);
        if (constructor == null) {
            throw new RuntimeException(IOCMessages.noAutobuildConstructor(clazz));
        }
        String description = this._classFactory.getConstructorLocation(constructor).toString();
        ConstructorServiceCreator creator = new ConstructorServiceCreator(this, description, constructor);
        return clazz.cast(creator.createObject());
    }
}

