/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import org.apache.tapestry.ioc.ObjectCreator;
import org.apache.tapestry.ioc.def.ServiceDef;
import org.apache.tapestry.ioc.internal.IOCMessages;
import org.slf4j.Logger;

public class RecursiveServiceCreationCheckWrapper
implements ObjectCreator {
    private final ServiceDef _serviceDef;
    private final ObjectCreator _delegate;
    private final Logger _logger;
    private boolean _locked;

    public RecursiveServiceCreationCheckWrapper(ServiceDef serviceDef, ObjectCreator delegate, Logger logger) {
        this._serviceDef = serviceDef;
        this._delegate = delegate;
        this._logger = logger;
    }

    public Object createObject() {
        if (this._locked) {
            throw new IllegalStateException(IOCMessages.recursiveServiceBuild(this._serviceDef));
        }
        this._locked = true;
        try {
            return this._delegate.createObject();
        }
        catch (RuntimeException ex) {
            this._logger.error(IOCMessages.serviceConstructionFailed(this._serviceDef, ex), (Throwable)ex);
            this._locked = false;
            throw ex;
        }
    }
}

