/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.tapestry.ioc.IdMatcher;
import org.apache.tapestry.ioc.ModuleBuilderSource;
import org.apache.tapestry.ioc.ServiceDecorator;
import org.apache.tapestry.ioc.ServiceResources;
import org.apache.tapestry.ioc.def.DecoratorDef;
import org.apache.tapestry.ioc.def.ServiceDef;
import org.apache.tapestry.ioc.internal.IdMatcherImpl;
import org.apache.tapestry.ioc.internal.OrIdMatcher;
import org.apache.tapestry.ioc.internal.ServiceDecoratorImpl;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.Defense;
import org.apache.tapestry.ioc.internal.util.InternalUtils;
import org.apache.tapestry.ioc.services.ClassFactory;

public class DecoratorDefImpl
implements DecoratorDef {
    private final String _decoratorId;
    private final Method _decoratorMethod;
    private final IdMatcher _idMatcher;
    private final String[] _constraints;
    private final ClassFactory _classFactory;

    public DecoratorDefImpl(String decoratorId, Method decoratorMethod, String[] patterns, String[] constraints, ClassFactory classFactory) {
        this._decoratorId = Defense.notBlank(decoratorId, "decoratorId");
        this._decoratorMethod = Defense.notNull(decoratorMethod, "decoratorMethod");
        List<IdMatcher> matchers = CollectionFactory.newList();
        for (String pattern : Defense.notNull(patterns, "patterns")) {
            IdMatcherImpl matcher = new IdMatcherImpl(pattern);
            matchers.add(matcher);
        }
        this._idMatcher = new OrIdMatcher(matchers);
        this._constraints = constraints != null ? constraints : new String[]{};
        this._classFactory = classFactory;
    }

    public String toString() {
        return InternalUtils.asString(this._decoratorMethod, this._classFactory);
    }

    public String[] getConstraints() {
        return this._constraints;
    }

    public String getDecoratorId() {
        return this._decoratorId;
    }

    public ServiceDecorator createDecorator(ModuleBuilderSource moduleBuilderSource, ServiceResources resources) {
        return new ServiceDecoratorImpl(this._decoratorMethod, moduleBuilderSource, resources, this._classFactory);
    }

    public boolean matches(ServiceDef serviceDef) {
        String serviceId = serviceDef.getServiceId();
        return this._idMatcher.matches(serviceId);
    }
}

