/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.PartitionStateInfo;
import kafka.api.Request$;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.kafka.KafkaTestUtils$;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t=e!B\u0001\u0003\u0001\ta!AD&bM.\fG+Z:u+RLGn\u001d\u0006\u0003\u0007\u0011\tQa[1gW\u0006T!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)Ui\u0011AB\u0005\u0003-\u0019\u0011q\u0001T8hO&tw\rC\u0003\u0019\u0001\u0011\u0005!$\u0001\u0004=S:LGOP\u0002\u0001)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%IaH\u0001\u0007u.Dun\u001d;\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\t1\fgn\u001a\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#E\u0001\u0004TiJLgn\u001a\u0005\u0007S\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u000fi\\\u0007j\\:uA!91\u0006\u0001a\u0001\n\u0013a\u0013A\u0002>l!>\u0014H/F\u0001.!\tqa&\u0003\u00020\u001f\t\u0019\u0011J\u001c;\t\u000fE\u0002\u0001\u0019!C\u0005e\u0005Q!p\u001b)peR|F%Z9\u0015\u0005M2\u0004C\u0001\b5\u0013\t)tB\u0001\u0003V]&$\bbB\u001c1\u0003\u0003\u0005\r!L\u0001\u0004q\u0012\n\u0004BB\u001d\u0001A\u0003&Q&A\u0004{WB{'\u000f\u001e\u0011\t\u000fm\u0002!\u0019!C\u0005Y\u0005\u0019\"p[\"p]:,7\r^5p]RKW.Z8vi\"1Q\b\u0001Q\u0001\n5\nAC_6D_:tWm\u0019;j_:$\u0016.\\3pkR\u0004\u0003bB \u0001\u0005\u0004%I\u0001L\u0001\u0011u.\u001cVm]:j_:$\u0016.\\3pkRDa!\u0011\u0001!\u0002\u0013i\u0013!\u0005>l'\u0016\u001c8/[8o)&lWm\\;uA!I1\t\u0001a\u0001\u0002\u0004%I\u0001R\u0001\nu>|7.Z3qKJ,\u0012!\u0012\t\u0003\r\u001ek\u0011\u0001\u0001\u0004\u0005\u0011\u0002!\u0011JA\tF[\n,G\rZ3e5>|7.Z3qKJ\u001c\"aR\u0007\t\u0011-;%Q1A\u0005\u00021\u000b\u0011B_6D_:tWm\u0019;\u0016\u00035\u0003\"AT)\u000f\u00059y\u0015B\u0001)\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011qE\u0015\u0006\u0003!>A\u0001\u0002V$\u0003\u0002\u0003\u0006I!T\u0001\u000bu.\u001cuN\u001c8fGR\u0004\u0003\"\u0002\rH\t\u00031FCA#X\u0011\u0015YU\u000b1\u0001N\u0011\u001dIvI1A\u0005\u0002i\u000b1b\u001d8baNDw\u000e\u001e#jeV\t1\f\u0005\u0002]?6\tQL\u0003\u0002_I\u0005\u0011\u0011n\\\u0005\u0003Av\u0013AAR5mK\"1!m\u0012Q\u0001\nm\u000bAb\u001d8baNDw\u000e\u001e#je\u0002Bq\u0001Z$C\u0002\u0013\u0005!,\u0001\u0004m_\u001e$\u0015N\u001d\u0005\u0007M\u001e\u0003\u000b\u0011B.\u0002\u000f1|w\rR5sA!91i\u0012b\u0001\n\u0003AW#A5\u0011\u0005)tW\"A6\u000b\u00051l\u0017AB:feZ,'O\u0003\u0002D\u0011%\u0011qn\u001b\u0002\u00105>|7*Z3qKJ\u001cVM\u001d<fe\"1\u0011o\u0012Q\u0001\n%\f!B_8pW\u0016,\u0007/\u001a:!\u0011)\u0019x\t%A\u0001\u0004\u0003\u0006I\u0001^\u0001\u0004q\u0012\u001a\u0004\u0003\u0002\bvA5J!A^\b\u0003\rQ+\b\u000f\\33\u0011\u001dAxI1A\u0005\u0002}\t!!\u001b9\t\ri<\u0005\u0015!\u0003!\u0003\rI\u0007\u000f\t\u0005\by\u001e\u0013\r\u0011\"\u0001-\u0003\u0011\u0001xN\u001d;\t\ry<\u0005\u0015!\u0003.\u0003\u0015\u0001xN\u001d;!\u0011%\t\ta\u0012b\u0001\n\u0003\t\u0019!A\u0004gC\u000e$xN]=\u0016\u0005\u0005\u0015\u0001c\u00016\u0002\b%\u0019\u0011\u0011B6\u0003)9KujU3sm\u0016\u00148I\u001c=o\r\u0006\u001cGo\u001c:z\u0011!\tia\u0012Q\u0001\n\u0005\u0015\u0011\u0001\u00034bGR|'/\u001f\u0011\t\u0011\u0005EqI1A\u0005\u00021\n!\"Y2uk\u0006d\u0007k\u001c:u\u0011\u001d\t)b\u0012Q\u0001\n5\n1\"Y2uk\u0006d\u0007k\u001c:uA!9\u0011\u0011D$\u0005\u0002\u0005m\u0011\u0001C:ikR$wn\u001e8\u0015\u0003MB1\"a\b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\"\u0005i!p\\8lK\u0016\u0004XM]0%KF$2aMA\u0012\u0011!9\u0014QDA\u0001\u0002\u0004)\u0005BB9\u0001A\u0003&Q\tC\u0006\u0002*\u0001\u0001\r\u00111A\u0005\n\u0005-\u0012\u0001\u0003>l\u00072LWM\u001c;\u0016\u0005\u00055\u0002\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\tu.\u001cG.[3oi*\u0019\u0011q\u0007\u0006\u0002\r%\u0003\u0014\n^3d\u0013\u0011\tY$!\r\u0003\u0011i[7\t\\5f]RD1\"a\u0010\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002B\u0005a!p[\"mS\u0016tGo\u0018\u0013fcR\u00191'a\u0011\t\u0013]\ni$!AA\u0002\u00055\u0002\u0002CA$\u0001\u0001\u0006K!!\f\u0002\u0013i\\7\t\\5f]R\u0004\u0003\u0002CA&\u0001\t\u0007I\u0011B\u0010\u0002\u0015\t\u0014xn[3s\u0011>\u001cH\u000fC\u0004\u0002P\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u0017\t\u0014xn[3s\u0011>\u001cH\u000f\t\u0005\t\u0003'\u0002\u0001\u0019!C\u0005Y\u0005Q!M]8lKJ\u0004vN\u001d;\t\u0013\u0005]\u0003\u00011A\u0005\n\u0005e\u0013A\u00042s_.,'\u000fU8si~#S-\u001d\u000b\u0004g\u0005m\u0003\u0002C\u001c\u0002V\u0005\u0005\t\u0019A\u0017\t\u000f\u0005}\u0003\u0001)Q\u0005[\u0005Y!M]8lKJ\u0004vN\u001d;!\u0011-\t\u0019\u0007\u0001a\u0001\u0002\u0004%I!!\u001a\u0002\u0015\t\u0014xn[3s\u0007>tg-\u0006\u0002\u0002hA!\u0011\u0011NA8\u001b\t\tYGC\u0002m\u0003[R\u0011aA\u0005\u0005\u0003c\nYGA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bCA;\u0001\u0001\u0007\t\u0019!C\u0005\u0003o\naB\u0019:pW\u0016\u00148i\u001c8g?\u0012*\u0017\u000fF\u00024\u0003sB\u0011bNA:\u0003\u0003\u0005\r!a\u001a\t\u0011\u0005u\u0004\u0001)Q\u0005\u0003O\n1B\u0019:pW\u0016\u00148i\u001c8gA!QA\u000e\u0001a\u0001\u0002\u0004%I!!!\u0016\u0005\u0005\r\u0005\u0003BA5\u0003\u000bKA!a\"\u0002l\tY1*\u00194lCN+'O^3s\u0011-\tY\t\u0001a\u0001\u0002\u0004%I!!$\u0002\u0015M,'O^3s?\u0012*\u0017\u000fF\u00024\u0003\u001fC\u0011bNAE\u0003\u0003\u0005\r!a!\t\u0011\u0005M\u0005\u0001)Q\u0005\u0003\u0007\u000bqa]3sm\u0016\u0014\b\u0005C\u0006\u0002\u0018\u0002\u0001\r\u00111A\u0005\n\u0005e\u0015\u0001\u00039s_\u0012,8-\u001a:\u0016\u0005\u0005m\u0005CBAO\u0003CkU*\u0004\u0002\u0002 *!\u0011qSA7\u0013\u0011\t\u0019+a(\u0003\u0011A\u0013x\u000eZ;dKJD1\"a*\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002*\u0006a\u0001O]8ek\u000e,'o\u0018\u0013fcR\u00191'a+\t\u0013]\n)+!AA\u0002\u0005m\u0005\u0002CAX\u0001\u0001\u0006K!a'\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0003\"CAZ\u0001\u0001\u0007I\u0011BA[\u0003\u001dQ8NU3bIf,\"!a.\u0011\u00079\tI,C\u0002\u0002<>\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002@\u0002\u0001\r\u0011\"\u0003\u0002B\u0006Y!p\u001b*fC\u0012Lx\fJ3r)\r\u0019\u00141\u0019\u0005\no\u0005u\u0016\u0011!a\u0001\u0003oC\u0001\"a2\u0001A\u0003&\u0011qW\u0001\tu.\u0014V-\u00193zA!I\u00111\u001a\u0001A\u0002\u0013%\u0011QW\u0001\fEJ|7.\u001a:SK\u0006$\u0017\u0010C\u0005\u0002P\u0002\u0001\r\u0011\"\u0003\u0002R\u0006y!M]8lKJ\u0014V-\u00193z?\u0012*\u0017\u000fF\u00024\u0003'D\u0011bNAg\u0003\u0003\u0005\r!a.\t\u0011\u0005]\u0007\u0001)Q\u0005\u0003o\u000bAB\u0019:pW\u0016\u0014(+Z1es\u0002Ba!a7\u0001\t\u0003a\u0015!\u0003>l\u0003\u0012$'/Z:t\u0011\u0019\ty\u000e\u0001C\u0001\u0019\u0006i!M]8lKJ\fE\r\u001a:fgNDq!a9\u0001\t\u0003\tY#A\b{_>\\W-\u001a9fe\u000ec\u0017.\u001a8u\u0011\u001d\t9\u000f\u0001C\u0005\u00037\tac]3ukB,UNY3eI\u0016$'l\\8lK\u0016\u0004XM\u001d\u0005\b\u0003W\u0004A\u0011BA\u000e\u0003a\u0019X\r^;q\u000b6\u0014W\r\u001a3fI.\u000bgm[1TKJ4XM\u001d\u0005\b\u0003_\u0004A\u0011AA\u000e\u0003\u0015\u0019X\r^;q\u0011\u001d\t\u0019\u0010\u0001C\u0001\u00037\t\u0001\u0002^3be\u0012|wO\u001c\u0005\b\u0003o\u0004A\u0011AA}\u0003-\u0019'/Z1uKR{\u0007/[2\u0015\u0007M\nY\u0010C\u0004\u0002~\u0006U\b\u0019A'\u0002\u000bQ|\u0007/[2\t\u000f\t\u0005\u0001\u0001\"\u0001\u0003\u0004\u0005a1/\u001a8e\u001b\u0016\u001c8/Y4fgR)1G!\u0002\u0003\b!9\u0011Q`A\u0000\u0001\u0004i\u0005\u0002\u0003B\u0005\u0003\u007f\u0004\rAa\u0003\u0002\u001b5,7o]1hKR{gI]3r!\u001d\u0011iAa\u0005N\u0005/i!Aa\u0004\u000b\u0007\tEA%\u0001\u0003vi&d\u0017\u0002\u0002B\u000b\u0005\u001f\u00111!T1q!\r\t#\u0011D\u0005\u0004\u00057\u0011#aB%oi\u0016<WM\u001d\u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0010)\u0015\u0019$\u0011\u0005B\u0012\u0011\u001d\tiP!\bA\u00025C\u0001B!\u0003\u0003\u001e\u0001\u0007!Q\u0005\t\u0006\u001d\n\u001dR*L\u0005\u0004\u0005+\u0011\u0006b\u0002B\u0001\u0001\u0011\u0005!1\u0006\u000b\u0006g\t5\"q\u0006\u0005\b\u0003{\u0014I\u00031\u0001N\u0011!\u0011\tD!\u000bA\u0002\tM\u0012\u0001C7fgN\fw-Z:\u0011\t9\u0011)$T\u0005\u0004\u0005oy!!B!se\u0006L\bb\u0002B\u001e\u0001\u0011%!QH\u0001\u0014EJ|7.\u001a:D_:4\u0017nZ;sCRLwN\\\u000b\u0003\u0005\u007f\u0001BA!\u0004\u0003B%!!1\tB\b\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0005\u000f\u0002A\u0011\u0002B\u001f\u0003U\u0001(o\u001c3vG\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:DqAa\u0013\u0001\t\u0003\u0011i%\u0001\u0006fm\u0016tG/^1mYf,BAa\u0014\u0003XQ1!\u0011\u000bB:\u0005\u007f\"BAa\u0015\u0003jA!!Q\u000bB,\u0019\u0001!\u0001B!\u0017\u0003J\t\u0007!1\f\u0002\u0002)F!!Q\fB2!\rq!qL\u0005\u0004\u0005Cz!a\u0002(pi\"Lgn\u001a\t\u0004\u001d\t\u0015\u0014b\u0001B4\u001f\t\u0019\u0011I\\=\t\u0013\t-$\u0011\nCA\u0002\t5\u0014\u0001\u00024v]\u000e\u0004RA\u0004B8\u0005'J1A!\u001d\u0010\u0005!a$-\u001f8b[\u0016t\u0004\u0002\u0003B;\u0005\u0013\u0002\rAa\u001e\u0002\u000fQLW.Z8viB!!\u0011\u0010B>\u001b\u0005!\u0011b\u0001B?\t\t!A+[7f\u0011!\u0011\tI!\u0013A\u0002\t]\u0014\u0001C5oi\u0016\u0014h/\u00197\t\u000f\t\u0015\u0005\u0001\"\u0003\u0003\b\u0006ir/Y5u+:$\u0018\u000e\\'fi\u0006$\u0017\r^1JgB\u0013x\u000e]1hCR,G\rF\u00034\u0005\u0013\u0013Y\tC\u0004\u0002~\n\r\u0005\u0019A'\t\u000f\t5%1\u0011a\u0001[\u0005I\u0001/\u0019:uSRLwN\u001c")
public class KafkaTestUtils
implements Logging {
    private final String zkHost;
    private int zkPort;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final String brokerHost;
    private int org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort;
    private KafkaConfig org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf;
    private KafkaServer org$apache$spark$streaming$kafka$KafkaTestUtils$$server;
    private Producer<String, String> producer;
    private boolean zkReady;
    private boolean brokerReady;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private String zkHost() {
        return this.zkHost;
    }

    private int zkPort() {
        return this.zkPort;
    }

    private void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    private int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    private int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    private EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    private void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    private ZkClient zkClient() {
        return this.zkClient;
    }

    private void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    private int org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort_$eq(int x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort = x$1;
    }

    public KafkaConfig org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf_$eq(KafkaConfig x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf = x$1;
    }

    public KafkaServer org$apache$spark$streaming$kafka$KafkaTestUtils$$server() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(KafkaServer x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server = x$1;
    }

    private Producer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    private boolean zkReady() {
        return this.zkReady;
    }

    private void zkReady_$eq(boolean x$1) {
        this.zkReady = x$1;
    }

    private boolean brokerReady() {
        return this.brokerReady;
    }

    private void brokerReady_$eq(boolean x$1) {
        this.brokerReady = x$1;
    }

    public String zkAddress() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}));
    }

    public String brokerAddress() {
        Predef$.MODULE$.assert(this.brokerReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka not setup yet or already torn down, cannot get broker address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerHost(), BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort())}));
    }

    public ZkClient zookeeperClient() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper client";
            }
        });
        return (ZkClient)Option$.MODULE$.apply((Object)this.zkClient()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Zookeeper client is not yet initialized");
            }
        });
    }

    private void setupEmbeddedZookeeper() {
        this.zookeeper_$eq(new EmbeddedZookeeper(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}))));
        this.zkPort_$eq(this.zookeeper().actualPort());
        this.zkClient_$eq(new ZkClient(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())})), this.zkSessionTimeout(), this.zkConnectionTimeout(), (ZkSerializer)ZKStringSerializer$.MODULE$));
        this.zkReady_$eq(true);
    }

    private void setupEmbeddedKafkaServer() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper should be set up beforehand";
            }
        });
        Utils$.MODULE$.startServiceOnPort(this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;

            public final Tuple2<KafkaServer, Object> apply(int port) {
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort_$eq(port);
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf_$eq(new KafkaConfig(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConfiguration()));
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(new KafkaServer(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf(), KafkaServer$.MODULE$.$lessinit$greater$default$2()));
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().startup();
                return new Tuple2((Object)this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server(), (Object)BoxesRunTime.boxToInteger((int)port));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new SparkConf(), "KafkaBroker");
        this.brokerReady_$eq(true);
    }

    public void setup() {
        this.setupEmbeddedZookeeper();
        this.setupEmbeddedKafkaServer();
    }

    public void teardown() {
        this.brokerReady_$eq(false);
        this.zkReady_$eq(false);
        if (this.producer() != null) {
            this.producer().close();
            this.producer_$eq(null);
        }
        if (this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server() != null) {
            this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().shutdown();
            this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(null);
        }
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf().logDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String f) {
                Utils$.MODULE$.deleteRecursively(new File(f));
            }
        });
        if (this.zkClient() != null) {
            this.zkClient().close();
            this.zkClient_$eq(null);
        }
        if (this.zookeeper() != null) {
            this.zookeeper().shutdown();
            this.zookeeper_$eq(null);
        }
    }

    public void createTopic(String topic) {
        AdminUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, AdminUtils$.MODULE$.createTopic$default$5());
        this.waitUntilMetadataIsPropagated(topic, 0);
    }

    public void sendMessages(String topic, Map<String, Integer> messageToFreq) {
        this.sendMessages(topic, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(messageToFreq).asScala()).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$1) {
                return x$1;
            }
        }).toSeq())));
    }

    public void sendMessages(String topic, scala.collection.immutable.Map<String, Object> messageToFreq) {
        String[] messages = (String[])((TraversableOnce)messageToFreq.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String s = (String)tuple2._1();
                    int freq = tuple2._2$mcI$sp();
                    Seq seq = (Seq)Seq$.MODULE$.fill(freq, (Function0)new Serializable(this, s){
                        public static final long serialVersionUID = 0L;
                        private final String s$1;

                        public final String apply() {
                            return this.s$1;
                        }
                        {
                            this.s$1 = s$1;
                        }
                    });
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        this.sendMessages(topic, messages);
    }

    public void sendMessages(String topic, String[] messages) {
        this.producer_$eq((Producer<String, String>)new Producer(new ProducerConfig(this.producerConfiguration())));
        this.producer().send((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])messages).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final KeyedMessage<String, String> apply(String x$2) {
                return new KeyedMessage(this.topic$2, (Object)x$2);
            }
            {
                this.topic$2 = topic$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KeyedMessage.class)))));
        this.producer().close();
        this.producer_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    public Properties org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("broker.id", "0");
        props.put("host.name", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort())).toString());
        props.put("log.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath());
        props.put("zookeeper.connect", this.zkAddress());
        props.put("log.flush.interval.messages", "1");
        props.put("replica.socket.timeout.ms", "1500");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties producerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerAddress());
        props.put("serializer.class", StringEncoder.class.getName());
        props.put("request.required.acks", "-1");
        return var1_1;
    }

    public <T> T eventually(Time timeout, Time interval, Function0<T> func) {
        long startTime = System.currentTimeMillis();
        return (T)this.tryAgain$1(1, timeout, interval, func, startTime);
    }

    private void waitUntilMetadataIsPropagated(String topic, int partition) {
        this.eventually(new Time(10000L), new Time(100L), (Function0)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            public final String topic$1;
            public final int partition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$isPropagated$1(this.topic$1, this.partition$1), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$waitUntilMetadataIsPropagated$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition [", ", ", "] metadata not propagated after timeout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$1, BoxesRunTime.boxToInteger((int)this.$outer.partition$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
                this.partition$1 = partition$1;
            }
        });
    }

    private final Either makeAttempt$1(Function0 func$1) {
        Throwable throwable2;
        block2: {
            Right right;
            try {
                right = package$.MODULE$.Right().apply(func$1.apply());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!NonFatal$.MODULE$.apply(throwable3)) break block2;
                Left left = package$.MODULE$.Left().apply((Object)throwable3);
                right = left;
            }
            return right;
        }
        throw throwable2;
    }

    private final Object tryAgain$1(int attempt, Time timeout$1, Time interval$1, Function0 func$1, long startTime$1) {
        Either either;
        block2: {
            Throwable e;
            while (true) {
                if ((either = this.makeAttempt$1(func$1)) instanceof Right) {
                    Object result;
                    Right right = (Right)either;
                    Object object = result = right.b();
                    return object;
                }
                if (!(either instanceof Left)) break block2;
                Left left = (Left)either;
                e = (Throwable)left.a();
                long duration = System.currentTimeMillis() - startTime$1;
                if (duration >= timeout$1.milliseconds()) break;
                Thread.sleep(interval$1.milliseconds());
                ++attempt;
            }
            throw new TimeoutException(e.getMessage());
        }
        throw new MatchError((Object)either);
    }

    public final boolean org$apache$spark$streaming$kafka$KafkaTestUtils$$isPropagated$1(String topic$1, int partition$1) {
        boolean bl;
        Option option = this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().apis().metadataCache().getPartitionInfo(topic$1, partition$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            PartitionStateInfo partitionState = (PartitionStateInfo)some.x();
            LeaderAndIsr leaderAndInSyncReplicas = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr();
            bl = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic$1, partition$1).isDefined() && Request$.MODULE$.isValidBrokerId(leaderAndInSyncReplicas.leader()) && leaderAndInSyncReplicas.isr().size() >= 1;
        } else {
            bl = false;
        }
        return bl;
    }

    public KafkaTestUtils() {
        Logging.class.$init$((Logging)this);
        this.zkHost = "localhost";
        this.zkPort = 0;
        this.zkConnectionTimeout = 60000;
        this.zkSessionTimeout = 6000;
        this.brokerHost = "localhost";
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort = 9092;
        this.zkReady = false;
        this.brokerReady = false;
    }

    public class EmbeddedZookeeper {
        private final String zkConnect;
        private final File snapshotDir;
        private final File logDir;
        private final ZooKeeperServer zookeeper;
        private final /* synthetic */ Tuple2 x$3;
        private final String ip;
        private final int port;
        private final NIOServerCnxnFactory factory;
        private final int actualPort;
        public final /* synthetic */ KafkaTestUtils $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public File snapshotDir() {
            return this.snapshotDir;
        }

        public File logDir() {
            return this.logDir;
        }

        public ZooKeeperServer zookeeper() {
            return this.zookeeper;
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public NIOServerCnxnFactory factory() {
            return this.factory;
        }

        public int actualPort() {
            return this.actualPort;
        }

        public void shutdown() {
            this.factory().shutdown();
            Utils$.MODULE$.deleteRecursively(this.snapshotDir());
            Utils$.MODULE$.deleteRecursively(this.logDir());
        }

        public /* synthetic */ KafkaTestUtils org$apache$spark$streaming$kafka$KafkaTestUtils$EmbeddedZookeeper$$$outer() {
            return this.$outer;
        }

        public EmbeddedZookeeper(KafkaTestUtils $outer, String zkConnect) {
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.snapshotDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), 500);
            String[] splits = zkConnect.split(":");
            Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt()));
            if (tuple2 != null) {
                Tuple2 tuple22;
                String ip = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                this.x$3 = tuple22 = new Tuple2((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port));
                this.ip = (String)this.x$3._1();
                this.port = this.x$3._2$mcI$sp();
                this.factory = new NIOServerCnxnFactory();
                this.factory().configure(new InetSocketAddress(this.ip(), this.port()), 16);
                this.factory().startup(this.zookeeper());
                this.actualPort = this.factory().getLocalPort();
                return;
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

