/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.subject.support;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DelegatingSubject;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.session.mgt.DefaultWebSessionContext;
import org.apache.shiro.web.subject.WebSubject;
import org.apache.shiro.web.util.WebUtils;

public class WebDelegatingSubject
extends DelegatingSubject
implements WebSubject {
    private static final long serialVersionUID = -1655724323350159250L;
    private final ServletRequest servletRequest;
    private final ServletResponse servletResponse;

    public WebDelegatingSubject(PrincipalCollection principals, boolean authenticated, String host, Session session, ServletRequest request, ServletResponse response, SecurityManager securityManager) {
        this(principals, authenticated, host, session, true, request, response, securityManager);
    }

    public WebDelegatingSubject(PrincipalCollection principals, boolean authenticated, String host, Session session, boolean sessionEnabled, ServletRequest request, ServletResponse response, SecurityManager securityManager) {
        super(principals, authenticated, host, session, sessionEnabled, securityManager);
        this.servletRequest = request;
        this.servletResponse = response;
    }

    @Override
    public ServletRequest getServletRequest() {
        return this.servletRequest;
    }

    @Override
    public ServletResponse getServletResponse() {
        return this.servletResponse;
    }

    protected boolean isSessionCreationEnabled() {
        boolean enabled = super.isSessionCreationEnabled();
        return enabled && WebUtils._isSessionCreationEnabled(this);
    }

    protected SessionContext createSessionContext() {
        DefaultWebSessionContext wsc = new DefaultWebSessionContext();
        String host = this.getHost();
        if (StringUtils.hasText((String)host)) {
            wsc.setHost(host);
        }
        wsc.setServletRequest(this.servletRequest);
        wsc.setServletResponse(this.servletResponse);
        return wsc;
    }
}

