/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.database;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.authority.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.authority.model.ShardingSpherePrivileges;
import org.apache.shardingsphere.authority.provider.database.DatabasePermittedPrivileges;
import org.apache.shardingsphere.authority.spi.PrivilegeProvider;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;

public final class DatabasePermittedPrivilegeProvider
implements PrivilegeProvider {
    private static final String USER_DATABASE_MAPPINGS_KEY = "user-database-mappings";
    private String userDatabaseMappings;

    public void init(Properties props) {
        this.userDatabaseMappings = props.getProperty(USER_DATABASE_MAPPINGS_KEY, "");
        this.checkUserDatabaseMappings();
    }

    private void checkUserDatabaseMappings() {
        Preconditions.checkArgument((!"".equals(this.userDatabaseMappings) ? 1 : 0) != 0, (String)"user-database-mappings configuration `%s` can not be null", (Object)this.userDatabaseMappings);
        Arrays.stream(this.userDatabaseMappings.split(",")).forEach(each -> Preconditions.checkArgument((each.contains("@") && each.contains("=") ? 1 : 0) != 0, (String)"user-database-mappings configuration `%s` is invalid, the configuration format should be like `username@hostname=database`", (Object)each));
    }

    public Map<Grantee, ShardingSpherePrivileges> build(AuthorityRuleConfiguration ruleConfig) {
        Map<ShardingSphereUser, Collection<String>> userDatabaseMappings = this.convertUserDatabases();
        return ruleConfig.getUsers().stream().collect(Collectors.toMap(ShardingSphereUser::getGrantee, each -> new DatabasePermittedPrivileges(this.getUserDatabases((ShardingSphereUser)each, userDatabaseMappings))));
    }

    private Map<ShardingSphereUser, Collection<String>> convertUserDatabases() {
        String[] mappings = this.userDatabaseMappings.split(",");
        HashMap<ShardingSphereUser, Collection<String>> result = new HashMap<ShardingSphereUser, Collection<String>>(mappings.length, 1.0f);
        for (String each : mappings) {
            String[] userDatabasePair = each.trim().split("=");
            ShardingSphereUser user = new ShardingSphereUser(userDatabasePair[0]);
            Collection databases = result.getOrDefault(user, new HashSet());
            databases.add(userDatabasePair[1]);
            result.putIfAbsent(user, databases);
        }
        return result;
    }

    private Collection<String> getUserDatabases(ShardingSphereUser user, Map<ShardingSphereUser, Collection<String>> userDatabaseMappings) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<ShardingSphereUser, Collection<String>> entry : userDatabaseMappings.entrySet()) {
            boolean isAnyOtherHost = entry.getKey().getGrantee().accept(user.getGrantee());
            if (!isAnyOtherHost && !user.equals((Object)entry.getKey())) continue;
            result.addAll(entry.getValue());
        }
        return result;
    }

    public String getType() {
        return "DATABASE_PERMITTED";
    }

    public Collection<Object> getTypeAliases() {
        return Collections.singleton("SCHEMA_PRIVILEGES_PERMITTED");
    }
}

