/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.converter;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.IOUtils;

public class ExcelToHtmlUtils {
    static final String EMPTY = "";
    private static final short EXCEL_COLUMN_WIDTH_FACTOR = 256;
    private static final int UNIT_OFFSET_LENGTH = 7;

    public static void appendAlign(StringBuilder style, short alignment) {
        switch (alignment) {
            case 2: {
                style.append("text-align: center; ");
                break;
            }
            case 6: {
                style.append("text-align: center; ");
                break;
            }
            case 4: {
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                style.append("text-align: justify; ");
                break;
            }
            case 1: {
                style.append("text-align: left; ");
                break;
            }
            case 3: {
                style.append("text-align: right; ");
            }
        }
    }

    public static CellRangeAddress[][] buildMergedRangesMap(HSSFSheet sheet) {
        CellRangeAddress[][] mergedRanges = new CellRangeAddress[1][];
        for (int m = 0; m < sheet.getNumMergedRegions(); ++m) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(m);
            int requiredHeight = cellRangeAddress.getLastRow() + 1;
            if (mergedRanges.length < requiredHeight) {
                CellRangeAddress[][] newArray = new CellRangeAddress[requiredHeight][];
                System.arraycopy(mergedRanges, 0, newArray, 0, mergedRanges.length);
                mergedRanges = newArray;
            }
            for (int r = cellRangeAddress.getFirstRow(); r <= cellRangeAddress.getLastRow(); ++r) {
                int requiredWidth = cellRangeAddress.getLastColumn() + 1;
                Object[] rowMerged = mergedRanges[r];
                if (rowMerged == null) {
                    rowMerged = new CellRangeAddress[requiredWidth];
                    mergedRanges[r] = rowMerged;
                } else {
                    int rowMergedLength = rowMerged.length;
                    if (rowMergedLength < requiredWidth) {
                        CellRangeAddress[] newRow = new CellRangeAddress[requiredWidth];
                        System.arraycopy(rowMerged, 0, newRow, 0, rowMergedLength);
                        mergedRanges[r] = newRow;
                        rowMerged = newRow;
                    }
                }
                Arrays.fill(rowMerged, cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn() + 1, cellRangeAddress);
            }
        }
        return mergedRanges;
    }

    public static String getBorderStyle(short xlsBorder) {
        String borderStyle;
        switch (xlsBorder) {
            case 0: {
                borderStyle = "none";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                borderStyle = "dotted";
                break;
            }
            case 3: 
            case 8: {
                borderStyle = "dashed";
                break;
            }
            case 6: {
                borderStyle = "double";
                break;
            }
            default: {
                borderStyle = "solid";
            }
        }
        return borderStyle;
    }

    public static String getBorderWidth(short xlsBorder) {
        String borderWidth;
        switch (xlsBorder) {
            case 8: 
            case 10: 
            case 12: {
                borderWidth = "2pt";
                break;
            }
            case 5: {
                borderWidth = "thick";
                break;
            }
            default: {
                borderWidth = "thin";
            }
        }
        return borderWidth;
    }

    public static String getColor(HSSFColor color) {
        StringBuilder stringBuilder = new StringBuilder(7);
        stringBuilder.append('#');
        for (short s : color.getTriplet()) {
            if (s < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(s));
        }
        String result = stringBuilder.toString();
        if (result.equals("#ffffff")) {
            return "white";
        }
        if (result.equals("#c0c0c0")) {
            return "silver";
        }
        if (result.equals("#808080")) {
            return "gray";
        }
        if (result.equals("#000000")) {
            return "black";
        }
        return result;
    }

    public static int getColumnWidthInPx(int widthUnits) {
        int pixels = widthUnits / 256 * 7;
        int offsetWidthUnits = widthUnits % 256;
        return pixels += Math.round((float)offsetWidthUnits / 36.57143f);
    }

    public static CellRangeAddress getMergedRange(CellRangeAddress[][] mergedRanges, int rowNumber, int columnNumber) {
        CellRangeAddress[] mergedRangeRowInfo = rowNumber < mergedRanges.length ? mergedRanges[rowNumber] : null;
        CellRangeAddress cellRangeAddress = mergedRangeRowInfo != null && columnNumber < mergedRangeRowInfo.length ? mergedRangeRowInfo[columnNumber] : null;
        return cellRangeAddress;
    }

    static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    static boolean isNotEmpty(String str) {
        return !ExcelToHtmlUtils.isEmpty(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HSSFWorkbook loadXls(File xlsFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(xlsFile);
        try {
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook((InputStream)inputStream);
            return hSSFWorkbook;
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
    }
}

