/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;

public class PortalDriverFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$driver$PortalDriverFilter == null ? (class$org$apache$pluto$driver$PortalDriverFilter = PortalDriverFilter.class$("org.apache.pluto.driver.PortalDriverFilter")) : class$org$apache$pluto$driver$PortalDriverFilter));
    private ServletContext servletContext;
    protected PortletContainer container;
    static /* synthetic */ Class class$org$apache$pluto$driver$PortalDriverFilter;

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        this.container = (PortletContainer)this.servletContext.getAttribute("portletContainer");
    }

    public void destroy() {
        this.container = null;
        this.servletContext = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest req = (HttpServletRequest)request;
            if (PortalRequestContext.getContext(req) == null) {
                PortalRequestContext ctx = this.doPortletPrepare(req, (HttpServletResponse)response);
                LOG.debug((Object)("Render Path: " + ctx.getRequestedPortalURL().getRenderPath()));
                LOG.debug((Object)("Servlet Path: " + ctx.getRequestedPortalURL().getServletPath()));
                PortalURL url = ctx.getRequestedPortalURL();
                if (url.getActionWindow() != null) {
                    return;
                }
            }
            String path = req.getServletPath();
            int idx = path.indexOf(".jsp");
            if (!path.endsWith(".jsp") && idx > 0) {
                String realPath = path.substring(0, idx + ".jsp".length());
                if (realPath.startsWith(req.getContextPath())) {
                    realPath = realPath.substring(req.getContextPath().length());
                }
                LOG.info((Object)("Forwarding to realPath: " + realPath));
                request.getRequestDispatcher(realPath).forward(request, response);
                return;
            }
        }
        filterChain.doFilter(request, response);
    }

    public PortalRequestContext doPortletPrepare(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PortletWindowConfig actionWindowConfig;
        PortalRequestContext portalRequestContext = new PortalRequestContext(this.getServletContext(), request, response);
        PortalURL portalURL = portalRequestContext.getRequestedPortalURL();
        String actionWindowId = portalURL.getActionWindow();
        PortletWindowConfig portletWindowConfig = actionWindowConfig = actionWindowId == null ? null : PortletWindowConfig.fromId(actionWindowId);
        if (actionWindowConfig != null) {
            PortletWindowImpl portletWindow = new PortletWindowImpl(actionWindowConfig, portalURL);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing action request for window: " + portletWindow.getId().getStringId()));
            }
            try {
                this.container.doAction((PortletWindow)portletWindow, request, response);
            }
            catch (PortletContainerException ex) {
                throw new ServletException((Throwable)ex);
            }
            catch (PortletException ex) {
                throw new ServletException((Throwable)ex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Action request processed.\n\n");
            }
        }
        return portalRequestContext;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

