/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.IOException;
import java.util.HashMap;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType2;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType2;

public class CreateGradientShadingPDF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String file) throws IOException, COSVisitorException {
        PDDocument document = null;
        try {
            document = new PDDocument();
            PDPage page = new PDPage();
            document.addPage(page);
            COSDictionary fdict = new COSDictionary();
            fdict.setInt(COSName.FUNCTION_TYPE, 2);
            COSArray domain = new COSArray();
            domain.add((COSBase)COSInteger.get((long)0L));
            domain.add((COSBase)COSInteger.get((long)1L));
            COSArray c0 = new COSArray();
            c0.add((COSBase)COSFloat.get((String)"1"));
            c0.add((COSBase)COSFloat.get((String)"0"));
            c0.add((COSBase)COSFloat.get((String)"0"));
            COSArray c1 = new COSArray();
            c1.add((COSBase)COSFloat.get((String)"0.5"));
            c1.add((COSBase)COSFloat.get((String)"1"));
            c1.add((COSBase)COSFloat.get((String)"0.5"));
            fdict.setItem(COSName.DOMAIN, (COSBase)domain);
            fdict.setItem(COSName.C0, (COSBase)c0);
            fdict.setItem(COSName.C1, (COSBase)c1);
            fdict.setInt(COSName.N, 1);
            PDFunctionType2 func = new PDFunctionType2((COSBase)fdict);
            PDShadingType2 shading = new PDShadingType2(new COSDictionary());
            shading.setColorSpace((PDColorSpace)PDDeviceRGB.INSTANCE);
            shading.setShadingType(2);
            COSArray coords = new COSArray();
            coords.add((COSBase)COSInteger.get((long)100L));
            coords.add((COSBase)COSInteger.get((long)400L));
            coords.add((COSBase)COSInteger.get((long)400L));
            coords.add((COSBase)COSInteger.get((long)600L));
            shading.setCoords(coords);
            shading.setFunction((PDFunction)func);
            page.setResources(new PDResources());
            HashMap<String, PDShadingType2> shadings = new HashMap<String, PDShadingType2>();
            shadings.put("sh1", shading);
            page.getResources().setShadings(shadings);
            PDPageContentStream contentStream = new PDPageContentStream(document, page, true, false);
            contentStream.appendRawCommands("/sh1 sh\n");
            contentStream.close();
            document.save(file);
            document.close();
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    public static void main(String[] args) throws IOException, COSVisitorException {
        if (args.length != 1) {
            CreateGradientShadingPDF.usage();
        } else {
            CreateGradientShadingPDF creator = new CreateGradientShadingPDF();
            creator.create(args[0]);
        }
    }

    private static void usage() {
        System.err.println("usage: java org.apache.pdfbox.examples.pdmodel.CreateGradientShadingPDF <outputfile.pdf>");
    }
}

