/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.IOException;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class UsingTextMatrix {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String message, String outfile) throws IOException, COSVisitorException {
        PDDocument doc = null;
        try {
            int i;
            doc = new PDDocument();
            PDType1Font font = PDType1Font.HELVETICA;
            PDPage page = new PDPage();
            page.setMediaBox(PDPage.PAGE_SIZE_A4);
            doc.addPage(page);
            float fontSize = 12.0f;
            PDRectangle pageSize = page.findMediaBox();
            float centeredXPosition = (pageSize.getWidth() - fontSize / 1000.0f) / 2.0f;
            float stringWidth = font.getStringWidth(message);
            float centeredYPosition = (pageSize.getHeight() - stringWidth * fontSize / 1000.0f) / 3.0f;
            PDPageContentStream contentStream = new PDPageContentStream(doc, page, false, false);
            contentStream.setFont((PDFont)font, fontSize);
            contentStream.beginText();
            for (i = 0; i < 8; ++i) {
                contentStream.setTextRotation((double)i * Math.PI * 0.25, (double)centeredXPosition, (double)(pageSize.getHeight() - centeredYPosition));
                contentStream.drawString(message + " " + i);
            }
            for (i = 0; i < 8; ++i) {
                contentStream.setTextRotation((double)(-i) * Math.PI * 0.25, (double)centeredXPosition, (double)centeredYPosition);
                contentStream.drawString(message + " " + i);
            }
            contentStream.endText();
            contentStream.close();
            page = new PDPage();
            page.setMediaBox(PDPage.PAGE_SIZE_A4);
            doc.addPage(page);
            fontSize = 1.0f;
            contentStream = new PDPageContentStream(doc, page, false, false);
            contentStream.setFont((PDFont)font, fontSize);
            contentStream.beginText();
            for (i = 0; i < 10; ++i) {
                contentStream.setTextScaling((double)(12 + i * 6), (double)(12 + i * 6), 100.0, (double)(100 + i * 50));
                contentStream.drawString(message + " " + i);
            }
            contentStream.endText();
            contentStream.close();
            page = new PDPage();
            page.setMediaBox(PDPage.PAGE_SIZE_A4);
            doc.addPage(page);
            fontSize = 1.0f;
            contentStream = new PDPageContentStream(doc, page, false, false);
            contentStream.setFont((PDFont)font, fontSize);
            contentStream.beginText();
            i = 0;
            contentStream.setTextMatrix(12.0, 0.0, 0.0, 12.0, (double)centeredXPosition, (double)centeredYPosition * 1.5);
            contentStream.drawString(message + " " + i++);
            contentStream.setTextMatrix(0.0, 18.0, -18.0, 0.0, (double)centeredXPosition, (double)centeredYPosition * 1.5);
            contentStream.drawString(message + " " + i++);
            contentStream.setTextMatrix(-24.0, 0.0, 0.0, -24.0, (double)centeredXPosition, (double)centeredYPosition * 1.5);
            contentStream.drawString(message + " " + i++);
            contentStream.setTextMatrix(0.0, -30.0, 30.0, 0.0, (double)centeredXPosition, (double)centeredYPosition * 1.5);
            contentStream.drawString(message + " " + i++);
            contentStream.endText();
            contentStream.close();
            doc.save(outfile);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) {
        UsingTextMatrix app = new UsingTextMatrix();
        try {
            if (args.length != 2) {
                app.usage();
            } else {
                app.doIt(args[0], args[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <Message> <output-file>");
    }
}

