/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.encoding.bitpacking;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class IntBasedBitPackingGenerator {
    private static final String CLASS_NAME_PREFIX = "LemireBitPacking";

    public static void main(String[] args) throws Exception {
        String basePath = args[0];
        IntBasedBitPackingGenerator.generateScheme("LemireBitPackingBE", true, basePath);
        IntBasedBitPackingGenerator.generateScheme("LemireBitPackingLE", false, basePath);
    }

    private static void generateScheme(String className, boolean msbFirst, String basePath) throws IOException {
        int i;
        File file = new File(basePath + "/org/apache/parquet/column/values/bitpacking/" + className + ".java").getAbsoluteFile();
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileWriter fw = new FileWriter(file);
        fw.append("package org.apache.parquet.column.values.bitpacking;\n");
        fw.append("\n");
        fw.append("/**\n");
        fw.append(" * Based on the original implementation at at https://github.com/lemire/JavaFastPFOR/blob/master/src/integercompression/BitPacking.java\n");
        fw.append(" * Which is released under the\n");
        fw.append(" * Apache License Version 2.0 http://www.apache.org/licenses/.\n");
        fw.append(" * By Daniel Lemire, http://lemire.me/en/\n");
        fw.append(" * \n");
        fw.append(" * Scheme designed by D. Lemire\n");
        if (msbFirst) {
            fw.append(" * Adapted to pack from the Most Significant Bit first\n");
        }
        fw.append(" * \n");
        fw.append(" * @author automatically generated\n");
        fw.append(" * @see IntBasedBitPackingGenerator\n");
        fw.append(" *\n");
        fw.append(" */\n");
        fw.append("abstract class " + className + " {\n");
        fw.append("\n");
        fw.append("  private static final IntPacker[] packers = new IntPacker[32];\n");
        fw.append("  static {\n");
        for (i = 0; i < 32; ++i) {
            fw.append("    packers[" + i + "] = new Packer" + i + "();\n");
        }
        fw.append("  }\n");
        fw.append("\n");
        fw.append("  public static final IntPackerFactory factory = new IntPackerFactory() {\n");
        fw.append("    public IntPacker newIntPacker(int bitWidth) {\n");
        fw.append("      return packers[bitWidth];\n");
        fw.append("    }\n");
        fw.append("  };\n");
        fw.append("\n");
        for (i = 0; i < 32; ++i) {
            IntBasedBitPackingGenerator.generateClass(fw, i, msbFirst);
            fw.append("\n");
        }
        fw.append("}\n");
        fw.close();
    }

    private static void generateClass(FileWriter fw, int bitWidth, boolean msbFirst) throws IOException {
        int i;
        int mask = 0;
        for (i = 0; i < bitWidth; ++i) {
            mask <<= 1;
            mask |= 1;
        }
        fw.append("  private static final class Packer" + bitWidth + " extends IntPacker {\n");
        fw.append("\n");
        fw.append("    private Packer" + bitWidth + "() {\n");
        fw.append("      super(" + bitWidth + ");\n");
        fw.append("    }\n");
        fw.append("\n");
        fw.append("    public final void pack32Values(final int[] in, final int inPos, final int[] out, final int outPos) {\n");
        for (i = 0; i < bitWidth; ++i) {
            fw.append("      out[" + IntBasedBitPackingGenerator.align(i, 2) + " + outPos] =\n");
            int startIndex = i * 32 / bitWidth;
            int endIndex = ((i + 1) * 32 + bitWidth - 1) / bitWidth;
            for (int j = startIndex; j < endIndex; ++j) {
                if (j == startIndex) {
                    fw.append("          ");
                } else {
                    fw.append("\n        | ");
                }
                String shiftString = IntBasedBitPackingGenerator.getPackShiftString(bitWidth, i, startIndex, j, msbFirst);
                fw.append("((in[" + IntBasedBitPackingGenerator.align(j, 2) + " + inPos] & " + mask + ")" + shiftString + ")");
            }
            fw.append(";\n");
        }
        fw.append("    }\n");
        fw.append("    public final void unpack32Values(final int[] in, final int inPos, final int[] out, final int outPos) {\n");
        if (bitWidth > 0) {
            for (i = 0; i < 32; ++i) {
                fw.append("      out[" + IntBasedBitPackingGenerator.align(i, 2) + " + outPos] =");
                int byteIndex = i * bitWidth / 32;
                String shiftString = IntBasedBitPackingGenerator.getUnpackShiftString(bitWidth, i, msbFirst);
                fw.append(" ((in[" + IntBasedBitPackingGenerator.align(byteIndex, 2) + " + inPos] " + shiftString + ") & " + mask + ")");
                if (((i + 1) * bitWidth - 1) / 32 != byteIndex) {
                    int bitsRead = ((i + 1) * bitWidth - 1) % 32 + 1;
                    fw.append(" | ((in[" + IntBasedBitPackingGenerator.align(byteIndex + 1, 2) + " + inPos]");
                    if (msbFirst) {
                        fw.append(") >>> " + IntBasedBitPackingGenerator.align(32 - bitsRead, 2) + ")");
                    } else {
                        int lowerMask = 0;
                        for (int j = 0; j < bitsRead; ++j) {
                            lowerMask <<= 1;
                            lowerMask |= 1;
                        }
                        fw.append(" & " + lowerMask + ") << " + IntBasedBitPackingGenerator.align(bitWidth - bitsRead, 2) + ")");
                    }
                }
                fw.append(";\n");
            }
        }
        fw.append("    }\n");
        fw.append("  }\n");
    }

    private static String getUnpackShiftString(int bitWidth, int i, boolean msbFirst) {
        int shift;
        int regularShift = i * bitWidth % 32;
        String shiftString = msbFirst ? ((shift = 32 - (regularShift + bitWidth)) < 0 ? "<<  " + IntBasedBitPackingGenerator.align(-shift, 2) : ">>> " + IntBasedBitPackingGenerator.align(shift, 2)) : ">>> " + IntBasedBitPackingGenerator.align(regularShift, 2);
        return shiftString;
    }

    private static String getPackShiftString(int bitWidth, int integerIndex, int startIndex, int valueIndex, boolean msbFirst) {
        String shiftString;
        int regularShift = valueIndex * bitWidth % 32;
        if (msbFirst) {
            int shift = 32 - (regularShift + bitWidth);
            shiftString = valueIndex == startIndex && integerIndex * 32 % bitWidth != 0 ? " <<  " + IntBasedBitPackingGenerator.align(32 - (valueIndex + 1) * bitWidth % 32, 2) : (shift < 0 ? " >>> " + IntBasedBitPackingGenerator.align(-shift, 2) : " <<  " + IntBasedBitPackingGenerator.align(shift, 2));
        } else {
            shiftString = valueIndex == startIndex && integerIndex * 32 % bitWidth != 0 ? " >>> " + IntBasedBitPackingGenerator.align(32 - regularShift, 2) : " <<  " + IntBasedBitPackingGenerator.align(regularShift, 2);
        }
        return shiftString;
    }

    private static String align(int value, int digits) {
        String valueString = String.valueOf(value);
        StringBuilder result = new StringBuilder();
        for (int i = valueString.length(); i < digits; ++i) {
            result.append(" ");
        }
        result.append(valueString);
        return result.toString();
    }
}

