/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.io.IOException;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public abstract class RowSetNavigator
implements RangeIterator {
    SessionInterface session;
    long id;
    int size;
    int mode;
    boolean isIterator;
    int currentPos = -1;
    int rangePosition;

    public void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public abstract Object[] getCurrent();

    @Override
    public Object getCurrent(int n) {
        Object[] objectArray = this.getCurrent();
        if (objectArray == null) {
            return null;
        }
        return objectArray[n];
    }

    @Override
    public void setCurrent(Object[] objectArray) {
    }

    public long getRowid() {
        return 0L;
    }

    @Override
    public Object getRowidObject() {
        return null;
    }

    @Override
    public abstract Row getCurrentRow();

    public abstract void add(Object[] var1);

    public abstract boolean addRow(Row var1);

    @Override
    public abstract void remove();

    public abstract void clear();

    @Override
    public void reset() {
        this.currentPos = -1;
    }

    @Override
    public void release() {
        this.reset();
    }

    public void setSession(SessionInterface sessionInterface) {
        this.session = sessionInterface;
    }

    public SessionInterface getSession() {
        return this.session;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object[] getNext() {
        return this.next() ? this.getCurrent() : null;
    }

    @Override
    public boolean next() {
        if (this.hasNext()) {
            ++this.currentPos;
            return true;
        }
        if (this.size != 0) {
            this.currentPos = this.size;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.currentPos < this.size - 1;
    }

    @Override
    public Row getNextRow() {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    @Override
    public boolean setRowColumns(boolean[] blArray) {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    @Override
    public long getRowId() {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    public boolean beforeFirst() {
        this.reset();
        this.currentPos = -1;
        return true;
    }

    public boolean afterLast() {
        if (this.size == 0) {
            return false;
        }
        this.reset();
        this.currentPos = this.size;
        return true;
    }

    public boolean first() {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() {
        if (this.size == 0) {
            return false;
        }
        if (this.isAfterLast()) {
            this.beforeFirst();
        }
        while (this.hasNext()) {
            this.next();
        }
        return true;
    }

    public int getRowNumber() {
        return this.currentPos;
    }

    public boolean absolute(int n) {
        if (n < 0) {
            n += this.size;
        }
        if (n < 0) {
            this.beforeFirst();
            return false;
        }
        if (n >= this.size) {
            this.afterLast();
            return false;
        }
        if (this.size == 0) {
            return false;
        }
        if (n < this.currentPos) {
            this.beforeFirst();
        }
        while (n > this.currentPos) {
            this.next();
        }
        return true;
    }

    public boolean relative(int n) {
        int n2 = this.currentPos + n;
        if (n2 < 0) {
            this.beforeFirst();
            return false;
        }
        return this.absolute(n2);
    }

    public boolean previous() {
        return this.relative(-1);
    }

    public boolean isFirst() {
        return this.size > 0 && this.currentPos == 0;
    }

    public boolean isLast() {
        return this.size > 0 && this.currentPos == this.size - 1;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.size > 0 && this.currentPos == -1;
    }

    public boolean isAfterLast() {
        return this.size > 0 && this.currentPos == this.size;
    }

    public void close() {
    }

    public void writeSimple(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) throws IOException {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    public void readSimple(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) throws IOException {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    public abstract void write(RowOutputInterface var1, ResultMetaData var2) throws IOException;

    public abstract void read(RowInputInterface var1, ResultMetaData var2) throws IOException;

    public boolean isMemory() {
        return true;
    }

    @Override
    public int getRangePosition() {
        return this.rangePosition;
    }

    @Override
    public RangeVariable getRange() {
        return null;
    }
}

