/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashSet;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public class SetFunction
implements Serializable {
    private HashSet distinctValues;
    private boolean isDistinct;
    private int setType;
    private int dataType;
    private Type type;
    private int count;
    private boolean hasNull;
    private boolean every = true;
    private boolean some = false;
    private long currentLong;
    private double currentDouble;
    private BigDecimal currentBigDecimal;
    private Object currentValue;
    static final BigInteger multiplier = BigInteger.valueOf(0x100000000L);
    long hi;
    long lo;
    private double sk;
    private double vk;
    private long n;
    private boolean initialized;
    private boolean sample;

    SetFunction(int n, Type type, boolean bl) {
        this.setType = n;
        this.type = type;
        if (bl) {
            this.isDistinct = true;
            this.distinctValues = new HashSet();
        }
        if (n == 81 || n == 79) {
            this.sample = true;
        }
        if (type != null) {
            this.dataType = type.typeCode;
            if (type.isIntervalType()) {
                this.dataType = 10;
            }
        }
    }

    void add(Session session, Object object) {
        if (object == null) {
            this.hasNull = true;
            return;
        }
        if (this.isDistinct && !this.distinctValues.add(object)) {
            return;
        }
        ++this.count;
        switch (this.setType) {
            case 71: {
                return;
            }
            case 72: 
            case 75: {
                switch (this.dataType) {
                    case -6: 
                    case 4: 
                    case 5: {
                        this.currentLong += (long)((Number)object).intValue();
                        return;
                    }
                    case 10: {
                        if (object instanceof IntervalSecondData) {
                            this.addLong(((IntervalSecondData)object).units);
                            this.currentLong += (long)((IntervalSecondData)object).nanos;
                            if (Math.abs(this.currentLong) >= (long)DTIType.nanoScaleFactors[0]) {
                                this.addLong(this.currentLong / (long)DTIType.nanoScaleFactors[0]);
                                this.currentLong %= (long)DTIType.nanoScaleFactors[0];
                            }
                        } else if (object instanceof IntervalMonthData) {
                            this.addLong(((IntervalMonthData)object).units);
                        }
                        return;
                    }
                    case 25: {
                        this.addLong(((Number)object).longValue());
                        return;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.currentDouble += ((Number)object).doubleValue();
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.currentBigDecimal = this.currentBigDecimal == null ? (BigDecimal)object : this.currentBigDecimal.add((BigDecimal)object);
                        return;
                    }
                }
                throw Error.error(5563);
            }
            case 73: {
                if (this.currentValue == null) {
                    this.currentValue = object;
                    return;
                }
                if (this.type.compare(session, this.currentValue, object) > 0) {
                    this.currentValue = object;
                }
                return;
            }
            case 74: {
                if (this.currentValue == null) {
                    this.currentValue = object;
                    return;
                }
                if (this.type.compare(session, this.currentValue, object) < 0) {
                    this.currentValue = object;
                }
                return;
            }
            case 76: {
                if (!(object instanceof Boolean)) {
                    throw Error.error(5563);
                }
                this.every = this.every && (Boolean)object != false;
                return;
            }
            case 77: {
                if (!(object instanceof Boolean)) {
                    throw Error.error(5563);
                }
                this.some = this.some || (Boolean)object != false;
                return;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                this.addDataPoint((Number)object);
                return;
            }
            case 98: {
                this.currentValue = object;
                return;
            }
        }
        throw Error.runtimeError(201, "SetFunction");
    }

    Object getValue(Session session) {
        if (this.hasNull) {
            session.addWarning(Error.error(1003));
        }
        if (this.setType == 71) {
            return ValuePool.getInt(this.count);
        }
        if (this.count == 0) {
            return null;
        }
        switch (this.setType) {
            case 75: {
                switch (this.dataType) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return new Long(this.currentLong / (long)this.count);
                    }
                    case 25: {
                        long l = this.getLongSum().divide(BigInteger.valueOf(this.count)).longValue();
                        return new Long(l);
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble / (double)this.count);
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal.divide(new BigDecimal(this.count), 1);
                    }
                    case 10: {
                        BigInteger bigInteger = this.getLongSum().divide(BigInteger.valueOf(this.count));
                        if (!NumberType.isInLongLimits(bigInteger)) {
                            throw Error.error(3435);
                        }
                        if (((IntervalType)this.type).isDaySecondIntervalType()) {
                            return new IntervalSecondData(bigInteger.longValue(), this.currentLong, (IntervalType)this.type, true);
                        }
                        return IntervalMonthData.newIntervalMonth(bigInteger.longValue(), (IntervalType)this.type);
                    }
                }
                throw Error.runtimeError(201, "SetFunction");
            }
            case 72: {
                switch (this.dataType) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return new Long(this.currentLong);
                    }
                    case 25: {
                        return new BigDecimal(this.getLongSum());
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return new Double(this.currentDouble);
                    }
                    case 2: 
                    case 3: {
                        return this.currentBigDecimal;
                    }
                    case 10: {
                        BigInteger bigInteger = this.getLongSum();
                        if (!NumberType.isInLongLimits(bigInteger)) {
                            throw Error.error(3435);
                        }
                        if (((IntervalType)this.type).isDaySecondIntervalType()) {
                            return new IntervalSecondData(bigInteger.longValue(), this.currentLong, (IntervalType)this.type, true);
                        }
                        return IntervalMonthData.newIntervalMonth(bigInteger.longValue(), (IntervalType)this.type);
                    }
                }
                throw Error.runtimeError(201, "SetFunction");
            }
            case 73: 
            case 74: {
                return this.currentValue;
            }
            case 76: {
                return this.every ? Boolean.TRUE : Boolean.FALSE;
            }
            case 77: {
                return this.some ? Boolean.TRUE : Boolean.FALSE;
            }
            case 78: 
            case 79: {
                return this.getStdDev();
            }
            case 80: 
            case 81: {
                return this.getVariance();
            }
            case 98: {
                return this.currentValue;
            }
        }
        throw Error.runtimeError(201, "SetFunction");
    }

    static Type getType(int n, Type type) {
        if (n == 71) {
            return Type.SQL_INTEGER;
        }
        int n2 = type.isIntervalType() ? 10 : type.typeCode;
        switch (n) {
            case 75: {
                switch (n2) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 25: {
                        return type;
                    }
                }
                throw Error.error(5563);
            }
            case 72: {
                switch (n2) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return Type.SQL_BIGINT;
                    }
                    case 25: {
                        return Type.SQL_DECIMAL_BIGINT_SQR;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return Type.SQL_DOUBLE;
                    }
                    case 2: 
                    case 3: {
                        return Type.getType(type.typeCode, null, null, type.precision * 2L, type.scale);
                    }
                    case 10: {
                        return IntervalType.newIntervalType(type.typeCode, 9L, type.scale);
                    }
                }
                throw Error.error(5563);
            }
            case 73: 
            case 74: {
                if (type.isArrayType() || type.isLobType()) {
                    throw Error.error(5563);
                }
                return type;
            }
            case 76: 
            case 77: {
                if (!type.isBooleanType()) break;
                return Type.SQL_BOOLEAN;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                if (!type.isNumberType()) break;
                return Type.SQL_DOUBLE;
            }
            case 98: {
                return type;
            }
            default: {
                throw Error.runtimeError(201, "SetFunction");
            }
        }
        throw Error.error(5563);
    }

    void addLong(long l) {
        if (l != 0L) {
            if (l > 0L) {
                this.hi += l >> 32;
                this.lo += l & 0xFFFFFFFFL;
            } else if (l == Long.MIN_VALUE) {
                this.hi -= 0x80000000L;
            } else {
                long l2 = (l ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
                this.hi -= l2 >> 32;
                this.lo -= l2 & 0xFFFFFFFFL;
            }
        }
    }

    BigInteger getLongSum() {
        BigInteger bigInteger = BigInteger.valueOf(this.lo);
        BigInteger bigInteger2 = BigInteger.valueOf(this.hi);
        BigInteger bigInteger3 = bigInteger2.multiply(multiplier).add(bigInteger);
        return bigInteger3;
    }

    private void addDataPoint(Number number) {
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        if (!this.initialized) {
            this.n = 1L;
            this.sk = d;
            this.vk = 0.0;
            this.initialized = true;
            return;
        }
        ++this.n;
        long l = this.n - 1L;
        double d2 = this.sk - d * (double)l;
        this.vk += d2 * d2 / (double)this.n / (double)l;
        this.sk += d;
    }

    private Number getVariance() {
        if (!this.initialized) {
            return null;
        }
        return this.sample ? (this.n == 1L ? null : new Double(this.vk / (double)(this.n - 1L))) : new Double(this.vk / (double)this.n);
    }

    private Number getStdDev() {
        if (!this.initialized) {
            return null;
        }
        return this.sample ? (this.n == 1L ? null : new Double(Math.sqrt(this.vk / (double)(this.n - 1L)))) : new Double(Math.sqrt(this.vk / (double)this.n));
    }
}

