/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlSet
implements Iterable<URL> {
    private final Map<String, URL> urls;

    public UrlSet(ClassLoader classLoader) throws IOException {
        this(UrlSet.getUrls(classLoader));
    }

    public UrlSet(URL ... urls) {
        this(Arrays.asList(urls));
    }

    public UrlSet(Collection<URL> urls) {
        this.urls = new HashMap<String, URL>();
        for (URL location : urls) {
            try {
                this.urls.put(location.toExternalForm(), location);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private UrlSet(Map<String, URL> urls) {
        this.urls = urls;
    }

    public UrlSet include(UrlSet urlSet) {
        HashMap<String, URL> urls = new HashMap<String, URL>(this.urls);
        urls.putAll(urlSet.urls);
        return new UrlSet(urls);
    }

    public UrlSet include(URL url) {
        HashMap<String, URL> urls = new HashMap<String, URL>(this.urls);
        urls.put(url.toExternalForm(), url);
        return new UrlSet(urls);
    }

    public UrlSet exclude(UrlSet urlSet) {
        HashMap<String, URL> urls = new HashMap<String, URL>(this.urls);
        Map<String, URL> parentUrls = urlSet.urls;
        for (String url : parentUrls.keySet()) {
            urls.remove(url);
        }
        return new UrlSet(urls);
    }

    public UrlSet exclude(URL url) {
        HashMap<String, URL> urls = new HashMap<String, URL>(this.urls);
        urls.remove(url.toExternalForm());
        return new UrlSet(urls);
    }

    public UrlSet exclude(ClassLoader parent) throws IOException {
        return this.exclude(new UrlSet(parent));
    }

    public UrlSet exclude(File file) throws MalformedURLException {
        return this.exclude(this.relative(file));
    }

    public UrlSet exclude(String pattern) throws MalformedURLException {
        return this.filter(Filters.invert(Filters.patterns(pattern)));
    }

    public UrlSet excludeJavaExtDirs() throws MalformedURLException {
        String extDirs = System.getProperty("java.ext.dirs");
        return extDirs == null ? this : this.excludePaths(extDirs);
    }

    public UrlSet excludeJavaEndorsedDirs() throws MalformedURLException {
        String endorsedDirs = System.getProperty("java.endorsed.dirs");
        return endorsedDirs == null ? this : this.excludePaths(endorsedDirs);
    }

    public UrlSet excludeJavaHome() throws MalformedURLException {
        String path = System.getProperty("java.home");
        File java2 = new File(path);
        if (path.matches("/System/Library/Frameworks/JavaVM.framework/Versions/[^/]+/Home")) {
            java2 = java2.getParentFile();
        }
        return this.exclude(java2);
    }

    public UrlSet excludePaths(String pathString) throws MalformedURLException {
        String[] paths = pathString.split(File.pathSeparator);
        UrlSet urlSet = this;
        for (String path : paths) {
            File file = new File(path);
            urlSet = urlSet.exclude(file);
        }
        return urlSet;
    }

    public UrlSet filter(Filter filter) {
        HashMap<String, URL> urls = new HashMap<String, URL>();
        for (Map.Entry<String, URL> entry : this.urls.entrySet()) {
            String url = entry.getKey();
            if (!filter.accept(url)) continue;
            urls.put(url, entry.getValue());
        }
        return new UrlSet(urls);
    }

    public UrlSet matching(String pattern) {
        return this.filter(Filters.patterns(pattern));
    }

    public UrlSet relative(File file) throws MalformedURLException {
        String urlPath = file.toURI().toURL().toExternalForm();
        HashMap<String, URL> urls = new HashMap<String, URL>();
        for (Map.Entry<String, URL> entry : this.urls.entrySet()) {
            String url = entry.getKey();
            if (!url.startsWith(urlPath) && !url.startsWith("jar:" + urlPath)) continue;
            urls.put(url, entry.getValue());
        }
        return new UrlSet(urls);
    }

    public List<URL> getUrls() {
        return new ArrayList<URL>(this.urls.values());
    }

    public int size() {
        return this.urls.size();
    }

    @Override
    public Iterator<URL> iterator() {
        return this.getUrls().iterator();
    }

    private static List<URL> getUrls(ClassLoader classLoader) throws IOException {
        ArrayList<URL> list = new ArrayList<URL>();
        ArrayList<URL> urls = Collections.list(classLoader.getResources("META-INF"));
        for (URL url : urls) {
            String externalForm = url.toExternalForm();
            int i = externalForm.lastIndexOf("META-INF");
            externalForm = externalForm.substring(0, i);
            url = new URL(externalForm);
            list.add(url);
        }
        list.addAll(Collections.list(classLoader.getResources("")));
        return list;
    }

    public String toString() {
        return super.toString() + "[" + this.urls.size() + "]";
    }
}

