/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.SimpleLayout;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Computable;
import org.apache.openejb.util.ConfUtils;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Memoizer;

public class Log4jLog {
    protected Logger _logger = null;
    private LogCategory category;
    private String baseName;
    private static final String SUFFIX = ".Messages";
    private static final String OPENEJB = "org.apache.openejb";
    private static final Computable<String, String> heirarchyResolver = new Computable<String, String>(){

        @Override
        public String compute(String key) throws InterruptedException {
            int index = key.lastIndexOf(".");
            String parent = key.substring(0, index);
            if (parent.contains(Log4jLog.OPENEJB)) {
                return parent;
            }
            return null;
        }
    };
    private static final Computable<String, ResourceBundle> bundleResolver = new Computable<String, ResourceBundle>(){

        @Override
        public ResourceBundle compute(String baseName) throws InterruptedException {
            try {
                return ResourceBundle.getBundle(baseName + Log4jLog.SUFFIX);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
    };
    private static final Computable<Object[], Log4jLog> loggerResolver = new Computable<Object[], Log4jLog>(){

        @Override
        public Log4jLog compute(Object[] args) throws InterruptedException {
            Log4jLog logger = new Log4jLog();
            logger.category = (LogCategory)args[0];
            logger._logger = Logger.getLogger(logger.category.getName());
            logger.baseName = (String)args[1];
            return logger;
        }
    };
    private static final Computable<String, MessageFormat> messageFormatResolver = new Computable<String, MessageFormat>(){

        @Override
        public MessageFormat compute(String message) throws InterruptedException {
            return new MessageFormat(message);
        }
    };
    private static final Computable<String, String> heirarchyCache = new Memoizer<String, String>(heirarchyResolver);
    private static final Computable<String, ResourceBundle> bundleCache = new Memoizer<String, ResourceBundle>(bundleResolver);
    private static final Computable<Object[], Log4jLog> loggerCache = new Memoizer<Object[], Log4jLog>(loggerResolver);
    private static final Computable<String, MessageFormat> messageFormatCache = new Memoizer<String, MessageFormat>(messageFormatResolver);
    private static final String LOGGING_PROPERTIES_FILE = "logging.properties";
    private static final String EMBEDDED_PROPERTIES_FILE = "embedded.logging.properties";

    private static void configureInternal() throws IOException {
        System.setProperty("openjpa.Log", "log4j");
        SystemInstance system = SystemInstance.get();
        FileUtils base = system.getBase();
        File confDir = base.getDirectory("conf");
        File loggingPropertiesFile = new File(confDir, LOGGING_PROPERTIES_FILE);
        if (confDir.exists()) {
            if (loggingPropertiesFile.exists()) {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(loggingPropertiesFile));
                Properties props = new Properties();
                props.load(bis);
                Log4jLog.applyOverrides(props);
                Log4jLog.preprocessProperties(props);
                PropertyConfigurator.configure(props);
                try {
                    bis.close();
                }
                catch (IOException e) {}
            } else {
                Log4jLog.installLoggingPropertiesFile(loggingPropertiesFile);
            }
        } else {
            Log4jLog.configureEmbedded();
        }
    }

    private static void applyOverrides(Properties properties) {
        Properties system = SystemInstance.get().getProperties();
        for (Map.Entry<Object, Object> entry : system.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("log4j.") || key.equals("log4j.configuration")) continue;
            properties.put(key, entry.getValue());
        }
    }

    private static void preprocessProperties(Properties properties) {
        FileUtils base = SystemInstance.get().getBase();
        File confDir = new File(base.getDirectory(), "conf");
        File baseDir = base.getDirectory();
        File userDir = new File("foo").getParentFile();
        File[] paths = new File[]{confDir, baseDir, userDir};
        ArrayList<File> missing = new ArrayList<File>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.endsWith(".File")) continue;
            boolean found = false;
            for (int i = 0; i < paths.length && !found; ++i) {
                File path = paths[i];
                File logfile = new File(path, value);
                if (!logfile.getParentFile().exists()) continue;
                properties.setProperty(key, logfile.getAbsolutePath());
                found = true;
            }
            if (found) continue;
            File logfile = new File(paths[0], value);
            missing.add(logfile);
        }
        if (missing.size() > 0) {
            Logger logger = Log4jLog.getFallabckLogger();
            logger.error("Logging may not operate as expected.  The directories for the following files do not exist so no file can be created.  See the list below.");
            for (int i = 0; i < missing.size(); ++i) {
                File file = (File)missing.get(i);
                logger.error("[" + i + "] " + file.getAbsolutePath());
            }
        }
    }

    private static Logger getFallabckLogger() {
        Logger logger = Logger.getLogger("OpenEJB.logging");
        SimpleLayout simpleLayout = new SimpleLayout();
        ConsoleAppender newAppender = new ConsoleAppender(simpleLayout);
        logger.addAppender(newAppender);
        return logger;
    }

    private static void configureEmbedded() {
        URL resource = ConfUtils.getResource(EMBEDDED_PROPERTIES_FILE);
        Properties properties = Log4jLog.asProperies(resource);
        Log4jLog.applyOverrides(properties);
        if (resource != null) {
            PropertyConfigurator.configure(properties);
        } else {
            System.out.println("FATAL ERROR WHILE CONFIGURING LOGGING!!!. MISSING embedded.logging.properties FILE ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties asProperies(URL resource) {
        Properties properties = new Properties();
        InputStream in = null;
        try {
            in = resource.openStream();
            in = new BufferedInputStream(in);
            properties.load(in);
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
        return properties;
    }

    private static void installLoggingPropertiesFile(File loggingPropertiesFile) throws IOException {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(LOGGING_PROPERTIES_FILE);
        if (resource == null) {
            System.out.println("FATAL ERROR WHILE CONFIGURING LOGGING!!!. MISSING logging.properties FILE ");
            return;
        }
        InputStream in = resource.openStream();
        in = new BufferedInputStream(in);
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int i = in.read(buf);
        while (i != -1) {
            bao.write(buf);
            i = in.read(buf);
        }
        byte[] byteArray = bao.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(byteArray);
        Properties props = new Properties();
        props.load(bis);
        Log4jLog.preprocessProperties(props);
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(loggingPropertiesFile));
        bout.write(byteArray);
        PropertyConfigurator.configure(props);
        try {
            bout.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private String getMessage(String key, String baseName) {
        try {
            ResourceBundle bundle = bundleCache.compute(baseName);
            if (bundle != null) {
                String message = null;
                try {
                    message = bundle.getString(key);
                    return message;
                }
                catch (MissingResourceException e) {
                    String parentName = heirarchyCache.compute(baseName);
                    if (parentName == null) {
                        return key;
                    }
                    return this.getMessage(key, parentName);
                }
            }
            String parentName = heirarchyCache.compute(baseName);
            if (parentName == null) {
                return key;
            }
            return this.getMessage(key, parentName);
        }
        catch (InterruptedException interruptedException) {
            return key;
        }
    }

    public static Log4jLog getInstance(LogCategory category, String baseName) {
        try {
            Log4jLog logger = loggerCache.compute(new Object[]{category, baseName});
            return logger;
        }
        catch (InterruptedException e) {
            Log4jLog logger = new Log4jLog();
            logger.category = category;
            logger._logger = Logger.getLogger(category.getName());
            logger.baseName = baseName;
            return logger;
        }
    }

    public static Log4jLog getInstance(LogCategory category, Class clazz) {
        return Log4jLog.getInstance(category, Log4jLog.packageName(clazz));
    }

    private static String packageName(Class clazz) {
        String name = clazz.getName();
        return name.substring(0, name.lastIndexOf("."));
    }

    public Log4jLog getLogger(String moduleId) {
        return Log4jLog.getInstance(this.category, this.baseName);
    }

    private String formatMessage(String message, Object ... args) {
        try {
            MessageFormat mf = messageFormatCache.compute(message);
            String msg = mf.format(args);
            return msg;
        }
        catch (InterruptedException e) {
            return "Error in formatting message " + message;
        }
    }

    private Log4jLog() {
    }

    public boolean isDebugEnabled() {
        return this._logger.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this._logger.isEnabledFor(Level.ERROR);
    }

    public boolean isFatalEnabled() {
        return this._logger.isEnabledFor(Level.FATAL);
    }

    public boolean isInfoEnabled() {
        return this._logger.isInfoEnabled();
    }

    public boolean isWarningEnabled() {
        return this._logger.isEnabledFor(Level.WARN);
    }

    public String debug(String message) {
        if (this.isDebugEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this._logger.debug(msg);
            return msg;
        }
        return message;
    }

    public String debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this._logger.debug(msg);
            return msg;
        }
        return message;
    }

    public String debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this._logger.debug(msg, t);
            return msg;
        }
        return message;
    }

    public String debug(String message, Throwable t, Object ... args) {
        if (this.isDebugEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this._logger.debug(msg, t);
            return msg;
        }
        return message;
    }

    public String error(String message) {
        if (this.isErrorEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this._logger.error(msg);
            return msg;
        }
        return message;
    }

    public String error(String message, Object ... args) {
        if (this.isErrorEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this._logger.error(msg);
            return msg;
        }
        return message;
    }

    public String error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this._logger.error(msg, t);
            return msg;
        }
        return message;
    }

    public String error(String message, Throwable t, Object ... args) {
        if (this.isErrorEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this._logger.error(msg, t);
            return msg;
        }
        return message;
    }

    public String fatal(String message) {
        if (this.isFatalEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this._logger.fatal(msg);
            return msg;
        }
        return message;
    }

    public String fatal(String message, Object ... args) {
        if (this.isFatalEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this._logger.fatal(msg);
            return msg;
        }
        return message;
    }

    public String fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this._logger.fatal(msg, t);
            return msg;
        }
        return message;
    }

    public String fatal(String message, Throwable t, Object ... args) {
        if (this.isFatalEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this._logger.fatal(msg, t);
            return msg;
        }
        return message;
    }

    public String info(String message) {
        if (this.isInfoEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this._logger.info(msg);
            return msg;
        }
        return message;
    }

    public String info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this._logger.info(msg);
            return msg;
        }
        return message;
    }

    public String info(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this._logger.info(msg, t);
            return msg;
        }
        return message;
    }

    public String info(String message, Throwable t, Object ... args) {
        if (this.isInfoEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this._logger.info(msg, t);
            return msg;
        }
        return message;
    }

    public String warning(String message) {
        if (this.isWarningEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this._logger.warn(msg);
            return msg;
        }
        return message;
    }

    public String warning(String message, Object ... args) {
        if (this.isWarningEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this._logger.warn(msg);
            return msg;
        }
        return message;
    }

    public String warning(String message, Throwable t) {
        if (this.isWarningEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this._logger.warn(msg, t);
            return msg;
        }
        return message;
    }

    public String warning(String message, Throwable t, Object ... args) {
        if (this.isWarningEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this._logger.warn(msg, t);
            return msg;
        }
        return message;
    }

    static {
        try {
            String prop = System.getProperty("openejb.logger.external", "false");
            boolean externalLogging = Boolean.parseBoolean(prop);
            if (!externalLogging) {
                Log4jLog.configureInternal();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

