/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.rest;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.core.MultivaluedMap;

public class MultivaluedMapWithCaseInsensitiveKeySet<V>
implements MultivaluedMap<String, V> {
    private MultivaluedMap<String, V> delegate;

    public MultivaluedMapWithCaseInsensitiveKeySet(MultivaluedMap<String, V> map) {
        this.delegate = map;
    }

    @Override
    public void add(String key, V value) {
        this.delegate.add(key, value);
    }

    @Override
    public V getFirst(String key) {
        return this.delegate.getFirst(this.realKey(key));
    }

    @Override
    public void putSingle(String key, V value) {
        this.delegate.putSingle(key, value);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return MultivaluedMapWithCaseInsensitiveKeySet.getInsensitiveKeySet(this.delegate.keySet()).contains(key.toString());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public List<V> get(Object key) {
        return (List)this.delegate.get(this.realKey(key));
    }

    @Override
    public List<V> put(String key, List<V> value) {
        return this.delegate.put(key, value);
    }

    @Override
    public List<V> remove(Object key) {
        return (List)this.delegate.remove(this.realKey(key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<V>> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<String> keySet() {
        return MultivaluedMapWithCaseInsensitiveKeySet.getInsensitiveKeySet(this.delegate.keySet());
    }

    @Override
    public Collection<List<V>> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<String, List<V>>> entrySet() {
        return this.delegate.entrySet();
    }

    private static Set<String> getInsensitiveKeySet(Set<String> values) {
        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        set.addAll(values);
        return set;
    }

    private static Object lowerCase(Object key) {
        if (key instanceof String) {
            return ((String)key).toLowerCase();
        }
        return key;
    }

    private String realKey(Object key) {
        for (Map.Entry entry : this.delegate.entrySet()) {
            if (!((String)entry.getKey()).toLowerCase().equals(MultivaluedMapWithCaseInsensitiveKeySet.lowerCase(key))) continue;
            return (String)entry.getKey();
        }
        return null;
    }
}

