/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateful;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;

public class StatefulUserTransaction
implements UserTransaction {
    private final UserTransaction userTransaction;
    private final JtaEntityManagerRegistry jtaEntityManagerRegistry;

    public StatefulUserTransaction(UserTransaction userTransaction, JtaEntityManagerRegistry jtaEntityManagerRegistry) {
        this.userTransaction = userTransaction;
        this.jtaEntityManagerRegistry = jtaEntityManagerRegistry;
    }

    @Override
    public void begin() throws NotSupportedException, SystemException {
        this.userTransaction.begin();
        ThreadContext callContext = ThreadContext.getThreadContext();
        if (callContext == null) {
            return;
        }
        BeanContext beanContext = callContext.getBeanContext();
        if (beanContext.getComponentType() != BeanType.STATEFUL) {
            return;
        }
        Object primaryKey = callContext.getPrimaryKey();
        if (primaryKey == null) {
            return;
        }
        this.jtaEntityManagerRegistry.transactionStarted((String)beanContext.getDeploymentID(), primaryKey);
    }

    @Override
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        this.userTransaction.commit();
    }

    @Override
    public int getStatus() throws SystemException {
        return this.userTransaction.getStatus();
    }

    @Override
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.userTransaction.rollback();
    }

    @Override
    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.userTransaction.setRollbackOnly();
    }

    @Override
    public void setTransactionTimeout(int i) throws SystemException {
        this.userTransaction.setTransactionTimeout(i);
    }
}

