/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.jee.DataSource;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.KeyedCollection;
import org.apache.openejb.jee.Property;

public class ConvertDataSourceDefinitions
implements DynamicDeployer {
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        List<JndiConsumer> jndiConsumers = this.collectConsumers(appModule);
        KeyedCollection dataSources = new KeyedCollection();
        for (JndiConsumer consumer : jndiConsumers) {
            if (consumer == null) continue;
            dataSources.addAll(consumer.getDataSource());
        }
        for (DataSource dataSource : dataSources) {
            appModule.getResources().add(this.toResource(dataSource));
        }
        return appModule;
    }

    private Resource toResource(DataSource datasource) {
        String name = datasource.getName();
        name = name.replaceFirst("java:comp/env/", "");
        name = name.replaceFirst("java:", "");
        Resource def = new Resource(name, javax.sql.DataSource.class.getName());
        def.setJndi(datasource.getName().replaceFirst("java:", ""));
        def.setType("javax.sql.DataSource");
        Properties p = def.getProperties();
        ConvertDataSourceDefinitions.put(p, "JtaManaged", datasource.getTransactional());
        ConvertDataSourceDefinitions.put(p, "InitialSize", datasource.getInitialPoolSize());
        ConvertDataSourceDefinitions.put(p, "DefaultIsolationLevel", (Object)datasource.getIsolationLevel());
        ConvertDataSourceDefinitions.put(p, "LoginTimeout", datasource.getLoginTimeout());
        ConvertDataSourceDefinitions.put(p, "MinEvictableIdleTimeMillis", datasource.getMaxIdleTime());
        ConvertDataSourceDefinitions.put(p, "MaxIdle", datasource.getMaxPoolSize());
        ConvertDataSourceDefinitions.put(p, "MinIdle", datasource.getMinPoolSize());
        ConvertDataSourceDefinitions.put(p, "MaxStatements", datasource.getMaxStatements());
        ConvertDataSourceDefinitions.put(p, "Password", datasource.getPassword());
        ConvertDataSourceDefinitions.put(p, "JdbcUrl", datasource.getUrl());
        ConvertDataSourceDefinitions.put(p, "UserName", datasource.getUser());
        ConvertDataSourceDefinitions.put(p, "JdbcDriver", datasource.getClassName());
        ConvertDataSourceDefinitions.put(p, "PortNumber", datasource.getPortNumber());
        ConvertDataSourceDefinitions.put(p, "DatabaseName", datasource.getDatabaseName());
        ConvertDataSourceDefinitions.put(p, "Description", datasource.getDescription());
        ConvertDataSourceDefinitions.put(p, "ServerName", datasource.getServerName());
        ConvertDataSourceDefinitions.put(p, "Definition", this.rawDefinition(datasource));
        ConvertDataSourceDefinitions.put(p, "Origin", "Annotation");
        this.setProperties(datasource, p);
        ConvertDataSourceDefinitions.put(p, "JndiName", def.getJndi());
        return def;
    }

    private String rawDefinition(DataSource d) {
        try {
            Properties p = new Properties();
            ConvertDataSourceDefinitions.put(p, "transactional", d.getTransactional());
            ConvertDataSourceDefinitions.put(p, "initialPoolSize", d.getInitialPoolSize());
            ConvertDataSourceDefinitions.put(p, "isolationLevel", (Object)d.getIsolationLevel());
            ConvertDataSourceDefinitions.put(p, "loginTimeout", d.getLoginTimeout());
            ConvertDataSourceDefinitions.put(p, "maxIdleTime", d.getMaxIdleTime());
            ConvertDataSourceDefinitions.put(p, "maxPoolSize", d.getMaxPoolSize());
            ConvertDataSourceDefinitions.put(p, "maxStatements", d.getMaxStatements());
            ConvertDataSourceDefinitions.put(p, "minPoolSize", d.getMinPoolSize());
            ConvertDataSourceDefinitions.put(p, "portNumber", d.getPortNumber());
            ConvertDataSourceDefinitions.put(p, "databaseName", d.getDatabaseName());
            ConvertDataSourceDefinitions.put(p, "password", d.getPassword());
            ConvertDataSourceDefinitions.put(p, "serverName", d.getServerName());
            ConvertDataSourceDefinitions.put(p, "url", d.getUrl());
            ConvertDataSourceDefinitions.put(p, "user", d.getUser());
            this.setProperties(d, p);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            p.store(out, "");
            return new String(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Cannot canonicalize the @DataSourceDefinition %s as a properties string", d.getName()));
        }
    }

    private void setProperties(DataSource d, Properties p) {
        for (Property property : d.getProperty()) {
            String key = property.getName();
            String value = property.getValue();
            ConvertDataSourceDefinitions.put(p, key, value);
        }
    }

    private static void put(Properties properties, String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            return;
        }
        properties.put(key, value + "");
    }

    private List<JndiConsumer> collectConsumers(AppModule appModule) {
        JndiConsumer consumer;
        ArrayList<JndiConsumer> jndiConsumers = new ArrayList<JndiConsumer>();
        for (ClientModule module : appModule.getClientModules()) {
            consumer = module.getApplicationClient();
            if (consumer == null) continue;
            jndiConsumers.add(consumer);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            consumer = webModule.getWebApp();
            if (consumer == null) continue;
            jndiConsumers.add(consumer);
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            Collections.addAll(jndiConsumers, ejbModule.getEjbJar().getEnterpriseBeans());
        }
        if (appModule.getApplication() != null) {
            jndiConsumers.add(appModule.getApplication());
        }
        return jndiConsumers;
    }
}

