/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.util.ArrayList;
import java.util.List;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.service.DefaultLoaderService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;

public class OptimizedLoaderService
implements LoaderService {
    private static final Logger log = Logger.getInstance(LogCategory.OPENEJB.createChild("cdi"), OptimizedLoaderService.class);
    private final LoaderService loaderService;

    public OptimizedLoaderService() {
        this(new DefaultLoaderService());
    }

    public OptimizedLoaderService(LoaderService loaderService) {
        this.loaderService = loaderService;
    }

    @Override
    public <T> List<T> load(Class<T> serviceType) {
        return this.load(serviceType, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public <T> List<T> load(Class<T> serviceType, ClassLoader classLoader) {
        if (OpenWebBeansPlugin.class.equals(serviceType)) {
            return this.loadWebBeansPlugins(classLoader);
        }
        return this.loaderService.load(serviceType, classLoader);
    }

    private <T> List<T> loadWebBeansPlugins(ClassLoader loader) {
        String[] knownPlugins = new String[]{"org.apache.openejb.cdi.CdiPlugin", "org.apache.geronimo.openejb.cdi.GeronimoWebBeansPlugin", "org.apache.webbeans.jsf.plugin.OpenWebBeansJsfPlugin"};
        ArrayList list = new ArrayList();
        for (String name : knownPlugins) {
            Class<?> clazz;
            try {
                clazz = loader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            try {
                list.add(clazz.newInstance());
            }
            catch (Exception e) {
                log.error("Unable to load OpenWebBeansPlugin: " + name);
            }
        }
        return list;
    }
}

