/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.work;

import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkContext;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import org.apache.geronimo.connector.work.WorkContextHandler;
import org.apache.geronimo.transaction.manager.ImportedTransactionActiveException;
import org.apache.geronimo.transaction.manager.XAWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionContextHandler
implements WorkContextHandler<TransactionContext> {
    private final XAWork xaWork;

    public TransactionContextHandler(XAWork xaWork) {
        this.xaWork = xaWork;
    }

    @Override
    public void before(TransactionContext workContext) throws WorkCompletedException {
        if (workContext.getXid() != null) {
            try {
                long transactionTimeout = workContext.getTransactionTimeout();
                this.xaWork.begin(workContext.getXid(), transactionTimeout < 0L ? 0L : transactionTimeout);
            }
            catch (XAException e) {
                throw (WorkCompletedException)new WorkCompletedException("Transaction import failed for xid " + workContext.getXid(), "3").initCause(e);
            }
            catch (InvalidTransactionException e) {
                throw (WorkCompletedException)new WorkCompletedException("Transaction import failed for xid " + workContext.getXid(), "3").initCause(e);
            }
            catch (SystemException e) {
                throw (WorkCompletedException)new WorkCompletedException("Transaction import failed for xid " + workContext.getXid(), "3").initCause(e);
            }
            catch (ImportedTransactionActiveException e) {
                throw (WorkCompletedException)new WorkCompletedException("Transaction already active for xid " + workContext.getXid(), "2").initCause(e);
            }
        }
    }

    @Override
    public void after(TransactionContext workContext) throws WorkCompletedException {
        if (workContext.getXid() != null) {
            try {
                this.xaWork.end(workContext.getXid());
            }
            catch (XAException e) {
                throw (WorkCompletedException)new WorkCompletedException("Transaction end failed for xid " + workContext.getXid(), "3").initCause(e);
            }
            catch (SystemException e) {
                throw (WorkCompletedException)new WorkCompletedException("Transaction end failed for xid " + workContext.getXid(), "3").initCause(e);
            }
        }
    }

    @Override
    public boolean supports(Class<? extends WorkContext> clazz) {
        return TransactionContext.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean required() {
        return false;
    }
}

