/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import javax.transaction.TransactionManager;
import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.apache.geronimo.connector.outbound.ConnectionHandleInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionTrackingInterceptor;
import org.apache.geronimo.connector.outbound.MCFConnectionInterceptor;
import org.apache.geronimo.connector.outbound.SubjectInterceptor;
import org.apache.geronimo.connector.outbound.SubjectSource;
import org.apache.geronimo.connector.outbound.TCCLInterceptor;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.LocalTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.XATransactions;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericConnectionManager
extends AbstractConnectionManager {
    protected static final Logger log = LoggerFactory.getLogger(GenericConnectionManager.class);

    public GenericConnectionManager() {
    }

    public GenericConnectionManager(TransactionSupport transactionSupport, PoolingSupport pooling, SubjectSource subjectSource, ConnectionTracker connectionTracker, RecoverableTransactionManager transactionManager, ManagedConnectionFactory mcf, String name, ClassLoader classLoader) {
        super(new InterceptorsImpl(transactionSupport, pooling, subjectSource, name, connectionTracker, transactionManager, mcf, classLoader), transactionManager, mcf, name);
    }

    private static class InterceptorsImpl
    implements AbstractConnectionManager.Interceptors {
        private final ConnectionInterceptor stack;
        private final ConnectionInterceptor recoveryStack;
        private final PoolingSupport poolingSupport;

        public InterceptorsImpl(TransactionSupport transactionSupport, PoolingSupport pooling, SubjectSource subjectSource, String name, ConnectionTracker connectionTracker, TransactionManager transactionManager, ManagedConnectionFactory mcf, ClassLoader classLoader) {
            if (subjectSource == null && pooling instanceof PartitionedPool && ((PartitionedPool)pooling).isPartitionBySubject()) {
                throw new IllegalStateException("To use Subject in pooling, you need a SecurityDomain");
            }
            if (mcf == null) {
                throw new NullPointerException("No ManagedConnectionFactory supplied for " + name);
            }
            if (mcf instanceof javax.resource.spi.TransactionSupport) {
                javax.resource.spi.TransactionSupport txSupport = (javax.resource.spi.TransactionSupport)((Object)mcf);
                TransactionSupport.TransactionSupportLevel txSupportLevel = txSupport.getTransactionSupport();
                log.info("Runtime TransactionSupport level: " + (Object)((Object)txSupportLevel));
                if (txSupportLevel != null) {
                    if (txSupportLevel == TransactionSupport.TransactionSupportLevel.NoTransaction) {
                        transactionSupport = NoTransactions.INSTANCE;
                    } else if (txSupportLevel == TransactionSupport.TransactionSupportLevel.LocalTransaction) {
                        if (transactionSupport != NoTransactions.INSTANCE) {
                            transactionSupport = LocalTransactions.INSTANCE;
                        }
                    } else if (transactionSupport != NoTransactions.INSTANCE && transactionSupport != LocalTransactions.INSTANCE) {
                        transactionSupport = new XATransactions(true, false);
                    }
                }
            } else {
                log.info("No runtime TransactionSupport");
            }
            MCFConnectionInterceptor tail = new MCFConnectionInterceptor();
            ConnectionInterceptor stack = tail;
            stack = transactionSupport.addXAResourceInsertionInterceptor(stack, name);
            stack = pooling.addPoolingInterceptors(stack);
            if (log.isTraceEnabled()) {
                log.trace("Connection Manager " + name + " installed pool " + stack);
            }
            this.poolingSupport = pooling;
            stack = transactionSupport.addTransactionInterceptors(stack, transactionManager);
            if (subjectSource != null) {
                stack = new SubjectInterceptor(stack, subjectSource);
            }
            this.recoveryStack = transactionSupport.isRecoverable() ? new TCCLInterceptor(stack, classLoader) : null;
            stack = new ConnectionHandleInterceptor(stack);
            stack = new TCCLInterceptor(stack, classLoader);
            if (connectionTracker != null) {
                stack = new ConnectionTrackingInterceptor(stack, name, connectionTracker);
            }
            tail.setStack(stack);
            this.stack = stack;
            if (log.isDebugEnabled()) {
                StringBuilder s = new StringBuilder("ConnectionManager Interceptor stack;\n");
                stack.info(s);
                log.debug(s.toString());
            }
        }

        public ConnectionInterceptor getStack() {
            return this.stack;
        }

        public ConnectionInterceptor getRecoveryStack() {
            return this.recoveryStack;
        }

        public PoolingSupport getPoolingAttributes() {
            return this.poolingSupport;
        }
    }
}

