/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.openejb.client.ClientRuntimeException;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionFactory;
import org.apache.openejb.client.MulticastConnectionFactory;
import org.apache.openejb.client.SSLContextBuilder;

public class HttpConnectionFactory
implements ConnectionFactory {
    @Override
    public Connection getConnection(URI uri) throws IOException {
        return new HttpConnection(uri);
    }

    public static class HttpConnection
    implements Connection {
        private HttpURLConnection httpURLConnection;
        private InputStream inputStream;
        private OutputStream outputStream;
        private final URI uri;

        public HttpConnection(URI uri) throws IOException {
            Map<String, String> params;
            this.uri = uri;
            URL url = uri.toURL();
            try {
                params = MulticastConnectionFactory.URIs.parseParamters(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid uri " + uri.toString(), e);
            }
            this.httpURLConnection = (HttpURLConnection)url.openConnection();
            this.httpURLConnection.setDoOutput(true);
            int timeout = params.containsKey("connectTimeout") ? Integer.parseInt(params.get("connectTimeout")) : 10000;
            this.httpURLConnection.setConnectTimeout(timeout);
            if (params.containsKey("readTimeout")) {
                this.httpURLConnection.setReadTimeout(Integer.parseInt(params.get("readTimeout")));
            }
            if (params.containsKey("sslKeyStore") || params.containsKey("sslTrustStore")) {
                try {
                    ((HttpsURLConnection)this.httpURLConnection).setSSLSocketFactory(new SSLContextBuilder(params).build().getSocketFactory());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ClientRuntimeException(e.getMessage(), e);
                }
                catch (KeyManagementException e) {
                    throw new ClientRuntimeException(e.getMessage(), e);
                }
            }
            try {
                this.httpURLConnection.connect();
            }
            catch (IOException e) {
                this.httpURLConnection.connect();
            }
        }

        @Override
        public void discard() {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public void close() throws IOException {
            IOException exception;
            block7: {
                exception = null;
                if (this.inputStream != null) {
                    try {
                        this.inputStream.close();
                    }
                    catch (IOException e) {
                        exception = e;
                    }
                }
                if (this.outputStream != null) {
                    try {
                        this.outputStream.close();
                    }
                    catch (IOException e) {
                        if (exception != null) break block7;
                        exception = e;
                    }
                }
            }
            this.inputStream = null;
            this.outputStream = null;
            this.httpURLConnection = null;
            if (exception != null) {
                throw exception;
            }
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.outputStream == null) {
                this.outputStream = this.httpURLConnection.getOutputStream();
            }
            return this.outputStream;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.inputStream == null) {
                this.inputStream = this.httpURLConnection.getInputStream();
            }
            return this.inputStream;
        }
    }
}

