/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.client.Client;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionManager;
import org.apache.openejb.client.ConnectionStrategy;
import org.apache.openejb.client.ServerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomConnectionStrategy
implements ConnectionStrategy {
    private static final Logger LOGGER = Logger.getLogger("OpenEJB.client");
    private final Random random = new Random();

    @Override
    public Connection connect(ClusterMetaData cluster, ServerMetaData server) throws IOException {
        Set<URI> failed = Client.getFailed();
        URI[] locations = cluster.getLocations();
        if (locations.length == 0) {
            return this.connect(cluster, server.getLocation());
        }
        List<URI> available = Arrays.asList(locations);
        available.removeAll(failed);
        URI lastLocation = cluster.getLastLocation();
        if (available.size() > 2) {
            available.remove(lastLocation);
        }
        while (available.size() > 0) {
            URI uri = this.next(available);
            try {
                return this.connect(cluster, uri);
            }
            catch (IOException e) {
                failed.add(uri);
                available.remove(uri);
                LOGGER.log(Level.WARNING, "Random: Failover: Cannot connect to server(s): " + uri.toString() + " Exception: " + e.getMessage() + ".  Trying next.");
            }
            catch (Throwable e) {
                failed.add(uri);
                available.remove(uri);
                throw new RemoteException("Random: Failover: Cannot connect to server: " + uri.toString() + " due to an unkown exception in the OpenEJB client: ", e);
            }
        }
        if (available.size() == 0 && server.getLocation() != null && !failed.contains(server.getLocation())) {
            return this.connect(cluster, server.getLocation());
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < locations.length; ++i) {
            URI uri = locations[i];
            buffer.append((i != 0 ? ", " : "") + "Server #" + i + ": " + uri);
        }
        throw new RemoteException("Cannot connect to any servers: " + buffer.toString());
    }

    private URI next(List<URI> available) {
        int i = Math.abs(this.random.nextInt()) % available.size();
        URI uri = available.get(i);
        return uri;
    }

    protected Connection connect(ClusterMetaData cluster, URI uri) throws IOException {
        Connection connection = ConnectionManager.getConnection(uri);
        cluster.setLastLocation(connection.getURI());
        return connection;
    }
}

