/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.DefaultedThreadLocal;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandler;
import org.apache.openejb.client.ServerMetaData;

public class EJBObjectProxyHandle
implements Externalizable {
    public static ThreadLocal<Resolver> resolver = new DefaultedThreadLocal<ClientSideResovler>(new ClientSideResovler());
    EJBObjectHandler handler;

    public EJBObjectProxyHandle() {
    }

    public EJBObjectProxyHandle(EJBObjectHandler handler) {
        this.handler = handler;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        this.handler.client.writeExternal(out);
        this.handler.ejb.writeExternal(out);
        this.handler.server.writeExternal(out);
        out.writeObject(this.handler.primaryKey);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        ClientMetaData client = new ClientMetaData();
        EJBMetaDataImpl ejb = new EJBMetaDataImpl();
        ServerMetaData server = new ServerMetaData();
        client.readExternal(in);
        ejb.readExternal(in);
        server.readExternal(in);
        Object primaryKey = in.readObject();
        this.handler = EJBObjectHandler.createEJBObjectHandler(ejb, server, client, primaryKey);
    }

    private Object readResolve() throws ObjectStreamException {
        return resolver.get().resolve(this.handler);
    }

    public static class ClientSideResovler
    implements Resolver {
        public Object resolve(EJBObjectHandler handler) {
            return handler.createEJBObjectProxy();
        }
    }

    public static interface Resolver {
        public Object resolve(EJBObjectHandler var1);
    }
}

