/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.Response;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.ThrowableArtifact;

public class AuthenticationResponse
implements Response {
    private transient int responseCode = -1;
    private transient ClientMetaData identity;
    private transient ServerMetaData server;
    private transient Throwable deniedCause;

    public AuthenticationResponse() {
    }

    public AuthenticationResponse(int code) {
        this.responseCode = code;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public ClientMetaData getIdentity() {
        return this.identity;
    }

    public ServerMetaData getServer() {
        return this.server;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void setIdentity(ClientMetaData identity) {
        this.identity = identity;
    }

    public void setServer(ServerMetaData server) {
        this.server = server;
    }

    public Throwable getDeniedCause() {
        return this.deniedCause;
    }

    public void setDeniedCause(Throwable deniedCause) {
        this.deniedCause = deniedCause;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        this.responseCode = in.readByte();
        switch (this.responseCode) {
            case 1: {
                this.identity = new ClientMetaData();
                this.identity.readExternal(in);
                break;
            }
            case 2: {
                this.identity = new ClientMetaData();
                this.identity.readExternal(in);
                this.server = new ServerMetaData();
                this.server.readExternal(in);
                break;
            }
            case 3: {
                ThrowableArtifact ta = new ThrowableArtifact();
                ta.readExternal(in);
                this.deniedCause = ta.getThrowable();
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeByte((byte)this.responseCode);
        switch (this.responseCode) {
            case 1: {
                this.identity.writeExternal(out);
                break;
            }
            case 2: {
                this.identity.writeExternal(out);
                this.server.writeExternal(out);
                break;
            }
            case 3: {
                ThrowableArtifact ta = new ThrowableArtifact(this.deniedCause);
                ta.writeExternal(out);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        switch (this.responseCode) {
            case 1: {
                sb.append("AUTH_GRANTED:");
                sb.append(this.identity);
                break;
            }
            case 2: {
                sb.append("AUTH_REDIRECT:");
                sb.append(this.server);
                break;
            }
            case 3: {
                sb.append("AUTH_DENIED:");
                sb.append(this.deniedCause.toString());
            }
        }
        return sb.toString();
    }
}

