/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.Request;

public class AuthenticationRequest
implements Request {
    private transient String realm;
    private transient String username;
    private transient String credentials;

    public AuthenticationRequest() {
    }

    public AuthenticationRequest(String principal, String credentials) {
        this(null, principal, credentials);
    }

    public AuthenticationRequest(String realm, String principal, String credentials) {
        this.realm = realm;
        this.username = principal;
        this.credentials = credentials;
    }

    public byte getRequestType() {
        return 2;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUsername() {
        return this.username;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        this.realm = (String)in.readObject();
        this.username = (String)in.readObject();
        this.credentials = (String)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.realm);
        out.writeObject(this.username);
        out.writeObject(this.credentials);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.realm).append(':');
        sb.append(this.username);
        return sb.toString();
    }
}

