/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared.resource.ResourceLoader;
import org.apache.myfaces.shared.resource.ResourceLoaderWrapper;
import org.apache.myfaces.shared.resource.ResourceMeta;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

public class TempDirFileCacheResourceLoader
extends ResourceLoaderWrapper {
    public static final String INIT_PARAM_TEMPORAL_RESOURCEHANDLER_CACHE_ENABLED = "org.apache.myfaces.TEMPORAL_RESOURCEHANDLER_CACHE_ENABLED";
    public static final boolean INIT_PARAM_TEMPORAL_RESOURCEHANDLER_CACHE_ENABLED_DEFAULT = false;
    public static final String TEMP_FILES_LOCK_MAP = "oam.rh.TEMP_FILES_LOCK_MAP";
    private static final String TEMP_FOLDER_BASE_DIR = "oam-rh-cache/";
    private static final String TEMP_FILE_SUFFIX = ".tmp";
    private ResourceLoader delegate;
    private volatile File _tempDir;
    private int _resourceBufferSize = -1;

    public TempDirFileCacheResourceLoader(ResourceLoader delegate) {
        this.delegate = delegate;
        this.initialize();
    }

    public static boolean isValidCreateTemporalFiles(FacesContext facesContext) {
        if (WebConfigParamUtils.getBooleanInitParameter(facesContext.getExternalContext(), INIT_PARAM_TEMPORAL_RESOURCEHANDLER_CACHE_ENABLED, false)) {
            try {
                Map applicationMap = facesContext.getExternalContext().getApplicationMap();
                File tempdir = (File)applicationMap.get("javax.servlet.context.tempdir");
                File imagesDir = new File(tempdir, TEMP_FOLDER_BASE_DIR);
                if (!imagesDir.exists()) {
                    imagesDir.mkdirs();
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    protected void initialize() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        File tempdir = (File)applicationMap.get("javax.servlet.context.tempdir");
        File imagesDir = new File(tempdir, TEMP_FOLDER_BASE_DIR);
        if (!imagesDir.exists()) {
            imagesDir.mkdirs();
        } else {
            TempDirFileCacheResourceLoader.deleteDir(imagesDir);
            imagesDir.mkdirs();
        }
        this._tempDir = imagesDir;
        ConcurrentHashMap temporalFilesLockMap = new ConcurrentHashMap();
        facesContext.getExternalContext().getApplicationMap().put(TEMP_FILES_LOCK_MAP, temporalFilesLockMap);
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = TempDirFileCacheResourceLoader.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public URL getResourceURL(ResourceMeta resourceMeta) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (this.resourceExists(resourceMeta)) {
            File file = this.createOrGetTempFile(facesContext, resourceMeta);
            try {
                return file.toURL();
            }
            catch (MalformedURLException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public InputStream getResourceInputStream(ResourceMeta resourceMeta, Resource resource) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (this.resourceExists(resourceMeta)) {
            File file = this.createOrGetTempFile(facesContext, resourceMeta);
            try {
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public InputStream getResourceInputStream(ResourceMeta resourceMeta) {
        return this.getResourceInputStream(resourceMeta, null);
    }

    public boolean resourceExists(ResourceMeta resourceMeta) {
        return super.resourceExists(resourceMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createOrGetTempFile(FacesContext facesContext, ResourceMeta resourceMeta) {
        String identifier = resourceMeta.getResourceIdentifier();
        File file = this.getTemporalFile(resourceMeta);
        if (!file.exists()) {
            Map map = (Map)facesContext.getExternalContext().getApplicationMap().get(TEMP_FILES_LOCK_MAP);
            FileProducer creator = (FileProducer)map.get(identifier);
            if (creator == null) {
                TempDirFileCacheResourceLoader tempDirFileCacheResourceLoader = this;
                synchronized (tempDirFileCacheResourceLoader) {
                    creator = (FileProducer)map.get(identifier);
                    if (creator == null) {
                        creator = new FileProducer();
                        map.put(identifier, creator);
                    }
                }
            }
            if (!creator.isCreated()) {
                creator.createFile(facesContext, resourceMeta, file, this);
            }
        }
        return file;
    }

    private File getTemporalFile(ResourceMeta resourceMeta) {
        return new File(this._tempDir, resourceMeta.getResourceIdentifier() + TEMP_FILE_SUFFIX);
    }

    protected void createTemporalFileVersion(FacesContext facesContext, ResourceMeta resourceMeta, File target) {
        target.mkdirs();
        target.delete();
        InputStream inputStream = null;
        try {
            inputStream = this.getWrapped().getResourceInputStream(resourceMeta);
            FileOutputStream fileOutputStream = new FileOutputStream(target);
            byte[] buffer = new byte[this.getResourceBufferSize()];
            TempDirFileCacheResourceLoader.pipeBytes(inputStream, fileOutputStream, buffer);
        }
        catch (FileNotFoundException e) {
            throw new FacesException("Unexpected exception while create file:", (Throwable)e);
        }
        catch (IOException e) {
            throw new FacesException("Unexpected exception while create file:", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static void pipeBytes(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int length;
        while ((length = in.read(buffer)) >= 0) {
            out.write(buffer, 0, length);
        }
    }

    protected int getResourceBufferSize() {
        if (this._resourceBufferSize == -1) {
            this._resourceBufferSize = WebConfigParamUtils.getIntegerInitParameter(FacesContext.getCurrentInstance().getExternalContext(), "org.apache.myfaces.RESOURCE_BUFFER_SIZE", 2048);
        }
        return this._resourceBufferSize;
    }

    public ResourceLoader getWrapped() {
        return this.delegate;
    }

    public static class FileProducer {
        public volatile boolean created = false;

        public boolean isCreated() {
            return this.created;
        }

        public synchronized void createFile(FacesContext facesContext, ResourceMeta resourceMeta, File file, TempDirFileCacheResourceLoader loader) {
            if (!this.created) {
                loader.createTemporalFileVersion(facesContext, resourceMeta, file);
                this.created = true;
            }
        }
    }
}

