/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public final class NetworkUtil {
    private static final ReentrantLock lock = new ReentrantLock();
    private static final AtomicReference<LastPort> lastPort = new AtomicReference();

    private NetworkUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextAvailablePort() {
        ReentrantLock l = lock;
        l.lock();
        try {
            int n = NetworkUtil.getNextAvailablePort(new int[]{0});
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getNextAvailablePort(int[] portList) {
        ReentrantLock l = lock;
        l.lock();
        try {
            int port;
            ServerSocket s = null;
            try {
                s = NetworkUtil.create(portList);
                port = s.getLocalPort();
            }
            catch (IOException ioe) {
                port = -1;
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable e) {}
                }
            }
            lastPort.set(new LastPort(port, System.currentTimeMillis()));
            int n = port;
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int getNextAvailablePort(int min, int max, Collection<Integer> excluded) {
        ReentrantLock l = lock;
        l.lock();
        try {
            int port = -1;
            ServerSocket s = null;
            for (int i = min; i <= max; ++i) {
                try {
                    s = NetworkUtil.create(new int[]{i});
                    port = s.getLocalPort();
                    if (excluded != null && excluded.contains(port)) continue;
                    break;
                }
                catch (IOException ioe) {
                    port = -1;
                    continue;
                }
                finally {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable e) {}
                    }
                }
            }
            lastPort.set(new LastPort(port, System.currentTimeMillis()));
            int n = port;
            return n;
        }
        finally {
            l.unlock();
        }
    }

    private static ServerSocket create(int[] ports) throws IOException {
        for (int port : ports) {
            try {
                LastPort last = lastPort.get();
                if (null != last && port == last.port && System.currentTimeMillis() - last.time < 10000L) continue;
                return new ServerSocket(port);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        throw new IOException("No free port found");
    }

    public static String getLocalAddress(String start, String end) {
        return start + "localhost:" + NetworkUtil.getNextAvailablePort() + end;
    }

    private static final class LastPort {
        private final int port;
        private final long time;

        private LastPort(int port, long time) {
            this.port = port;
            this.time = time;
        }
    }
}

