/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.cache;

import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.color.CMMException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.ImageProvider;
import org.apache.myfaces.trinidadinternal.image.ImageProviderRequest;
import org.apache.myfaces.trinidadinternal.image.ImageProviderResponse;
import org.apache.myfaces.trinidadinternal.image.ImageRenderer;
import org.apache.myfaces.trinidadinternal.image.ImageType;
import org.apache.myfaces.trinidadinternal.image.ImageTypeManager;
import org.apache.myfaces.trinidadinternal.image.cache.Cache;
import org.apache.myfaces.trinidadinternal.image.cache.CacheEntry;
import org.apache.myfaces.trinidadinternal.image.cache.CacheException;
import org.apache.myfaces.trinidadinternal.image.cache.CacheKey;
import org.apache.myfaces.trinidadinternal.image.cache.CacheKeyFactory;
import org.apache.myfaces.trinidadinternal.image.cache.CacheUtils;
import org.apache.myfaces.trinidadinternal.image.cache.MapCacheEntry;
import org.apache.myfaces.trinidadinternal.image.cache.NameProvider;
import org.apache.myfaces.trinidadinternal.image.cache.PropertiesFilter;
import org.apache.myfaces.trinidadinternal.image.cache.SourceCheckingCacheEntry;
import org.apache.myfaces.trinidadinternal.image.encode.ImageEncoder;
import org.apache.myfaces.trinidadinternal.image.encode.ImageEncoderManager;
import org.apache.myfaces.trinidadinternal.image.util.FileUtils;
import org.apache.myfaces.trinidadinternal.image.util.MapArea;
import org.apache.myfaces.trinidadinternal.image.xml.ImageProviderRequestUtils;
import org.apache.myfaces.trinidadinternal.share.config.Configuration;
import org.apache.myfaces.trinidadinternal.share.io.InputStreamProvider;
import org.apache.myfaces.trinidadinternal.share.xml.XMLProvider;
import org.apache.myfaces.trinidadinternal.share.xml.XMLUtils;
import org.apache.myfaces.trinidadinternal.style.util.GraphicsUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemImageCache
implements ImageProvider,
ImageConstants {
    public static final String BLOCK_IMAGE_GENERATION = "org.apache.myfaces.trinidad.image.BlockImageGeneration";
    private String _realPath;
    private ConcurrentHashMap<String, Cache> _caches;
    private Cache _globalCache;
    private static final Hashtable<String, ImageProvider> _sSharedCaches = new Hashtable(19);
    static final String __IMX_EXTENSION = ".imx";
    private static final String _URI_DELIMITER = "/";
    private static final long _LAST_CHECK_INTERVAL = 10000L;
    private boolean _configNotChecked = true;
    private boolean _checkModified = true;
    private static final CacheEntry _MISS_ENTRY = new CacheEntry(null, -1, -1);
    private static final CacheEntry _RETRY_ENTRY = new CacheEntry(null, -1, -1);
    private static final String _CACHE_PATH_ERROR = "Could not get canonical path for image cache directory ";
    private static final String _CACHE_DIRECTORY_ERROR = "Could not create image cache directory ";
    private static final String _XML_ENCODING_ERROR = "Error while generating image metadata file ";
    private static final String _CREATE_CACHE_ERROR = "Could not create image cache for ";
    private static final String _XML_DECODING_ERROR = "Could not decode image metadata from ";
    private static final String _CACHE_KEY_ERROR = "Could not create cache key for image type ";
    private static final String _CACHE_KEY_FACTORY_ERROR = "No CacheKeyFactory registered for image type ";
    private static final String _METADATA_FILE_ERROR = "Could not locate metadata file ";
    private static final String _IMAGE_TYPE_ERROR = "No image type registered for ";
    private static final String _IMAGE_RENDERER_ERROR = "No ImageRenderer registered for image type ";
    private static final String _NAME_PROVIDER_ERROR = "No NameProvider registered for image type ";
    private static final String _NAME_PROVIDING_ERROR = "Could not get image file name name for image type ";
    private static final String _IMAGE_ENCODER_ERROR = "No ImageEncoder registered for image encoding type ";
    private static final String _IMAGE_ENCODING_EXTENSION_ERROR = "No file extension registered for image encoding type ";
    private static final String _XML_PROVIDER_ERROR = "Could not load XMLProvider";
    private static String _UTF8 = "UTF8";
    private static final String _CHINESE_LANGUAGE = "zh";
    private static final String _SIMPLIFIED_CHINESE_DIRECTORY = "zhs";
    private static final String _TRADITIONAL_CHINESE_DIRECTORY = "zht";
    private static final Integer _TEST_WIDTH = 23;
    private static final Integer _TEST_HEIGHT = 32;
    private static final String _GIF_ENABLED = "gifEnabled";
    private static final Hashtable<String, String> _sCanonicalPaths = new Hashtable(19);
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(FileSystemImageCache.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageProvider getSharedCache(String realPath) {
        ImageProvider cache = _sSharedCaches.get(realPath = FileSystemImageCache._getCanonicalPath(realPath));
        if (cache == null) {
            cache = new FileSystemImageCache(realPath);
            Hashtable<String, ImageProvider> hashtable = _sSharedCaches;
            synchronized (hashtable) {
                ImageProvider tmp = _sSharedCaches.get(realPath);
                if (tmp != null) {
                    cache = tmp;
                } else {
                    _sSharedCaches.put(realPath, cache);
                }
            }
        }
        return cache;
    }

    protected FileSystemImageCache(String realPath) {
        this._realPath = realPath;
        File f = new File(this._realPath);
        if (!f.exists() && !f.mkdirs()) {
            throw new IllegalArgumentException(_CACHE_DIRECTORY_ERROR + realPath);
        }
        this._caches = new ConcurrentHashMap(19);
    }

    @Override
    public ImageProviderResponse getImage(ImageContext context, ImageProviderRequest request) {
        try {
            Map<Object, Object> properties;
            ImageType type = this._getImageType(context, request);
            assert (type != null);
            Cache cache = this._getCache(context, type);
            assert (cache != null);
            Object key = null;
            key = request instanceof CacheKey ? request : this._getCacheKey(context, type, request);
            assert (key != null);
            CacheEntry entry = this._getImageFromCache(context, cache, key, request);
            if (entry != null) {
                if (entry == _MISS_ENTRY) {
                    return null;
                }
                if (entry == _RETRY_ENTRY) {
                    if (!this._shouldRetry(context)) {
                        return null;
                    }
                } else {
                    return entry;
                }
            }
            if ((properties = this._getFilteredProperties(context, type, request)) == null) {
                this._putMissEntry(context, type, request, cache, key);
                return null;
            }
            entry = this._getImageFromFileSystem(context, type, cache, key, properties);
            if (entry != null) {
                if (entry == _MISS_ENTRY) {
                    return null;
                }
                if (entry != _RETRY_ENTRY) {
                    return entry;
                }
            }
            return this._generateImage(context, type, request, cache, key, properties);
        }
        catch (CacheException e) {
            _LOG.warning((Throwable)e);
            return null;
        }
    }

    private void _loadCache(ImageContext context, Cache cache, boolean localized) throws CacheException {
        String[] files;
        File directory;
        String localeString = this._getLocaleString(context);
        String realPath = this._realPath + File.separatorChar;
        if (localized) {
            realPath = realPath + localeString + File.separatorChar;
        }
        if (!(directory = new File(realPath)).exists() && !directory.mkdir()) {
            this._error(_CACHE_DIRECTORY_ERROR + realPath);
        }
        if (_LOG.isFine()) {
            _LOG.fine("Initializing image cache: " + realPath + " ...");
        }
        if ((files = directory.list(IMXFilter.getInstance())) == null) {
            return;
        }
        long lastLog = 0L;
        for (int i = 0; i < files.length; ++i) {
            long current = System.currentTimeMillis();
            if (current - lastLog > 5000L) {
                if (_LOG.isFine()) {
                    _LOG.fine("Loading image " + i + " of " + files.length + " from image cache: " + realPath);
                }
                lastLog = current;
            }
            String imxName = files[i];
            String imxPath = realPath + imxName;
            XMLProvider parser = this._getXMLProvider(context);
            assert (parser != null);
            try {
                this._loadImage(context, cache, new File(imxPath), parser);
                continue;
            }
            catch (CacheException e) {
                _LOG.warning((Throwable)e);
            }
        }
        if (_LOG.isFine()) {
            _LOG.fine("Finished initializing image cache: " + realPath);
        }
    }

    private Cache _getCache(ImageContext context, ImageType type) throws CacheException {
        boolean localized = this._isTypeLocalized(type);
        String language = this._getLocaleString(context);
        Cache cache = null;
        cache = localized ? this._caches.get(language) : this._globalCache;
        if (cache != null) {
            return cache;
        }
        cache = new Cache();
        if (localized) {
            if (!this._caches.containsKey(language)) {
                this._caches.put(language, cache);
                this._loadCache(context, cache, localized);
            } else {
                cache = this._caches.get(language);
            }
        } else if (this._globalCache == null) {
            this._globalCache = cache;
            this._loadCache(context, cache, localized);
        } else {
            cache = this._globalCache;
        }
        if (cache == null) {
            String message = _CREATE_CACHE_ERROR + this._realPath;
            if (localized) {
                message = message + _URI_DELIMITER + language;
            }
            this._error(message);
        }
        return cache;
    }

    private CacheEntry _getImageFromCache(ImageContext context, Cache cache, Object key, ImageProviderRequest request) throws CacheException {
        long time;
        CacheEntry entry = cache.get(context, key);
        if (entry == null || entry == _MISS_ENTRY || entry == _RETRY_ENTRY) {
            return entry;
        }
        if (this._checkModified(context) && (time = System.currentTimeMillis()) > entry.getLastChecked() + 10000L) {
            if (!this._imageExists(entry.getImageURI())) {
                cache.remove(context, key, entry);
                return null;
            }
            if (!entry.isValid(context, request)) {
                cache.remove(context, key, entry);
                this._removeImageFromFileSystem(entry);
                return null;
            }
            entry.setLastChecked(time);
        }
        return entry;
    }

    private CacheEntry _getImageFromFileSystem(ImageContext context, ImageType type, Cache cache, Object key, Map<Object, Object> properties) throws CacheException {
        Object newKey;
        String name = this._getFileName(context, type, properties);
        assert (name != null);
        XMLProvider parser = null;
        do {
            String uniqueName;
            String path;
            File file;
            if (!(file = new File(path = this._getRealPath(context, type, uniqueName = cache.getUniqueName(name), __IMX_EXTENSION))).exists()) {
                cache.releaseUniqueName(uniqueName);
                return null;
            }
            if (parser == null) {
                parser = this._getXMLProvider(context);
                assert (parser != null);
            }
            newKey = null;
            try {
                newKey = this._loadImage(context, cache, file, parser);
            }
            catch (CacheException e) {
                _LOG.warning((Throwable)e);
            }
        } while (!key.equals(newKey));
        return cache.get(context, key);
    }

    private CacheEntry _generateImage(ImageContext context, ImageType type, ImageProviderRequest request, Cache cache, Object key, Map<Object, Object> properties) throws CacheException {
        ArrayMap responseProperties = new ArrayMap(3);
        byte[] imageData = null;
        try {
            imageData = this._renderImageLocal(context, type, properties, (Map<Object, Object>)responseProperties);
        }
        catch (CMMException e) {
            _LOG.warning((Throwable)e);
        }
        if (imageData == null) {
            this._putMissEntry(context, type, request, cache, key);
            return null;
        }
        cache = this._checkCacheExists(context, type);
        assert (cache != null);
        CacheEntry entry = this._getImageFromCache(context, cache, key, request);
        if (entry == null) {
            entry = this._getImageFromFileSystem(context, type, cache, key, properties);
        }
        if (entry != null && entry != _MISS_ENTRY && entry != _RETRY_ENTRY) {
            return entry;
        }
        String name = this._getFileName(context, type, properties);
        assert (name != null);
        String uniqueName = cache.getUniqueName(name);
        assert (uniqueName != null);
        File imxFile = this._writeImageMetadataFile(context, type, uniqueName, properties, (Map<Object, Object>)responseProperties);
        if (imxFile == null) {
            return null;
        }
        File imageFile = this._writeImageFile(context, type, uniqueName, imageData, properties);
        if (imageFile == null) {
            imxFile.delete();
            return null;
        }
        return this._putCachedImage(context, type, request, cache, key, uniqueName, properties, (Map<Object, Object>)responseProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _loadImage(ImageContext context, Cache cache, File imxFile, XMLProvider parser) throws CacheException {
        String imxPath = imxFile.getPath();
        String imxName = imxFile.getName();
        FileInputStream in = null;
        try {
            in = new FileInputStream(imxPath);
        }
        catch (FileNotFoundException fnfe) {
            this._error(_METADATA_FILE_ERROR, fnfe);
        }
        assert (in != null);
        Reader reader = this._getUTF8Reader(in);
        InputSource source = new InputSource(reader);
        source.setSystemId(imxPath);
        ImageProviderRequest request = null;
        try {
            request = ImageProviderRequestUtils.createImageProviderRequest(context, parser, source);
        }
        catch (SAXException e) {
            this._error(_XML_DECODING_ERROR + imxPath, e);
        }
        catch (IOException e) {
            this._error(_XML_DECODING_ERROR + imxPath, e);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                this._error(e);
            }
        }
        if (request == null) {
            return null;
        }
        ImageType type = this._getImageType(context, request);
        assert (type != null);
        Map<Object, Object> properties = request.getRenderProperties(context);
        assert (properties != null);
        int dotIndex = imxName.lastIndexOf(46);
        String baseName = dotIndex == -1 ? imxName : imxName.substring(0, dotIndex);
        StringBuffer uriBuffer = new StringBuffer(imxName.length() + 3);
        if (this._isTypeLocalized(type)) {
            uriBuffer.append(this._getLocaleString(context));
            uriBuffer.append(_URI_DELIMITER);
        }
        uriBuffer.append(baseName);
        String extension = this._getImageEncodingExtension(context, properties);
        assert (extension != null);
        uriBuffer.append(extension);
        String uri = uriBuffer.toString();
        if (!this._imageExists(uri)) {
            return null;
        }
        CacheKeyFactory keyFactory = this._getCacheKeyFactory(type);
        Object key = keyFactory.getCacheKey(context, properties);
        CacheEntry entry = this._createCacheEntry(context, type, uri, properties);
        cache.put(context, key, entry);
        return key;
    }

    private CacheEntry _putCachedImage(ImageContext context, ImageType type, ImageProviderRequest request, Cache cache, Object key, String name, Map<Object, Object> properties, Map<Object, Object> responseProperties) throws CacheException {
        if (request == key) {
            key = this._getCacheKey(context, type, request);
            assert (key != null);
        }
        boolean localized = this._isTypeLocalized(type);
        String language = this._getLocaleString(context);
        assert (language != null);
        String extension = this._getImageEncodingExtension(context, properties);
        assert (extension != null);
        int length = name.length() + extension.length();
        if (localized) {
            length += language.length();
        }
        StringBuffer buffer = new StringBuffer(length);
        if (localized) {
            buffer.append(language);
            buffer.append(_URI_DELIMITER);
        }
        buffer.append(name);
        buffer.append(extension);
        String uri = buffer.toString();
        CacheEntry entry = this._createCacheEntry(context, type, uri, responseProperties);
        cache.put(context, key, entry);
        return entry;
    }

    private void _putMissEntry(ImageContext context, ImageType type, ImageProviderRequest request, Cache cache, Object key) throws CacheException {
        if (request == key) {
            key = this._getCacheKey(context, type, request);
            assert (key != null);
        }
        cache.put(context, key, _MISS_ENTRY);
    }

    private void _removeImageFromFileSystem(CacheEntry entry) {
        String uri = entry.getImageURI();
        String imagePath = this._getRealPath(uri);
        File imageFile = new File(imagePath);
        imageFile.delete();
        String encoding = entry.getEncoding();
        ImageEncoderManager manager = ImageEncoderManager.getDefaultImageEncoderManager();
        String extension = manager.getImageExtension(encoding);
        String imxPath = imagePath.substring(0, imagePath.length() - extension.length());
        File imxFile = new File(imxPath + __IMX_EXTENSION);
        imxFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _renderImageLocal(ImageContext context, ImageType type, Map<Object, Object> properties, Map<Object, Object> responseProperties) throws CacheException {
        Configuration config = context.getConfiguration();
        if (Boolean.TRUE.equals(config.getProperty(BLOCK_IMAGE_GENERATION))) {
            responseProperties.put(WIDTH_RESPONSE_KEY, _TEST_WIDTH);
            responseProperties.put(HEIGHT_RESPONSE_KEY, _TEST_HEIGHT);
            Object o = properties.get(TABS_KEY);
            if (o != null) {
                int length = ((Object[])o).length;
                MapArea[] areas = new MapArea[length];
                for (int i = 0; i < length; ++i) {
                    areas[i] = new MapArea(new Rectangle(i, 0, 1, 1));
                }
                responseProperties.put(IMAGE_MAP_AREAS_RESPONSE_KEY, areas);
            }
            return new byte[0];
        }
        if (Boolean.TRUE.equals(config.getProperty(Configuration.HEADLESS)) || !GraphicsUtils.isGraphicalEnvironment()) {
            if ("http://myfaces.apache.org/uix/image".equals(type.getNamespaceURI()) && "colorizedIcon".equals(type.getLocalName())) {
                return this._readColorizedIconData(context, properties, responseProperties);
            }
            return null;
        }
        ImageRenderer renderer = this._getImageRenderer(type);
        assert (renderer != null);
        Image image = renderer.renderImage(context, properties, responseProperties);
        if (image == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageEncoder encoder = this._getImageEncoder(context, properties);
            assert (encoder != null);
            encoder.encodeImage(image, out);
        }
        catch (IOException e) {
            this._error(e);
        }
        finally {
            image.flush();
        }
        return out.toByteArray();
    }

    private byte[] _readImageData(InputStream in) throws IOException, CacheException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = in.read(buffer)) >= 0) {
            out.write(buffer, 0, length);
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _readSourceIconData(InputStreamProvider provider) throws IOException, CacheException {
        InputStream in = null;
        try {
            in = provider.openInputStream();
        }
        catch (IOException e) {
            return null;
        }
        byte[] iconData = null;
        try {
            iconData = this._readImageData(in);
        }
        finally {
            in.close();
        }
        return iconData;
    }

    private boolean _shouldRetry(ImageContext context) {
        return true;
    }

    private File _writeImageFile(ImageContext context, ImageType type, String name, byte[] data, Map<Object, Object> properties) throws CacheException {
        String extension = this._getImageEncodingExtension(context, properties);
        String path = this._getRealPath(context, type, name, extension);
        File file = new File(path);
        try {
            FileOutputStream out = new FileOutputStream(file);
            ((OutputStream)out).write(data);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            this._error(e);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File _writeImageMetadataFile(ImageContext context, ImageType type, String name, Map<Object, Object> properties, Map<Object, Object> responseProperties) throws CacheException {
        String path = this._getRealPath(context, type, name, __IMX_EXTENSION);
        File file = new File(path);
        PrintWriter writer = null;
        try {
            if (file.exists() || !file.createNewFile()) {
                return null;
            }
            writer = new PrintWriter(FileUtils.getUTF8Writer(path));
        }
        catch (IOException e) {
            this._error(e);
        }
        try {
            this._writeImageProviderRequest(context, type, properties, responseProperties, writer);
        }
        finally {
            writer.flush();
            writer.close();
            if (writer.checkError()) {
                if (file.exists()) {
                    file.delete();
                }
                this._error(_XML_ENCODING_ERROR + path);
            }
        }
        return file;
    }

    private void _writeImageProviderRequest(ImageContext context, ImageType type, Map<Object, Object> properties, Map<Object, Object> responseProperties, PrintWriter writer) throws CacheException {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        try {
            ImageProviderRequestUtils.encodeImageProviderRequest(context, type.getNamespaceURI(), type.getLocalName(), type, properties, responseProperties, writer);
        }
        catch (IllegalArgumentException e) {
            throw new CacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache _checkCacheExists(ImageContext context, ImageType type) throws CacheException {
        boolean localized = this._isTypeLocalized(type);
        String language = this._getLocaleString(context);
        String directoryPath = this._getRealPath(localized ? language : "");
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            if (localized) {
                ConcurrentHashMap<String, Cache> concurrentHashMap = this._caches;
                synchronized (concurrentHashMap) {
                    File parent;
                    if (this._caches.containsKey(language)) {
                        this._caches.remove(language);
                    }
                    if ((parent = directory.getParentFile()) != null && !parent.exists()) {
                        FileSystemImageCache fileSystemImageCache = this;
                        synchronized (fileSystemImageCache) {
                            this._globalCache = null;
                        }
                    }
                }
            }
            FileSystemImageCache fileSystemImageCache = this;
            synchronized (fileSystemImageCache) {
                this._globalCache = null;
            }
            directory.mkdirs();
        }
        return this._getCache(context, type);
    }

    private boolean _checkModified(ImageContext context) {
        if (this._configNotChecked) {
            this._checkModified = true;
            this._configNotChecked = false;
        }
        return this._checkModified;
    }

    private CacheEntry _createCacheEntry(ImageContext context, ImageType type, String uri, Map<Object, Object> properties) {
        int width = this._getIntSize(properties, WIDTH_RESPONSE_KEY);
        int height = this._getIntSize(properties, HEIGHT_RESPONSE_KEY);
        MapArea[] areas = (MapArea[])properties.get(IMAGE_MAP_AREAS_RESPONSE_KEY);
        String encoding = this._getImageEncoding(context, properties);
        if (areas == null) {
            Object checkSource = type.getProperty(ImageType.CHECK_SOURCE_PROPERTY);
            if (Boolean.TRUE.equals(checkSource)) {
                return new SourceCheckingCacheEntry(uri, width, height, encoding);
            }
            return new CacheEntry(uri, width, height, encoding);
        }
        return new MapCacheEntry(uri, width, height, areas, encoding);
    }

    private void _error(String message) throws CacheException {
        throw new CacheException(message);
    }

    private void _error(Throwable t) throws CacheException {
        throw new CacheException(t);
    }

    private void _error(String message, Throwable t) throws CacheException {
        throw new CacheException(message, t);
    }

    private Object _getCacheKey(ImageContext context, ImageType type, ImageProviderRequest request) throws CacheException {
        CacheKeyFactory keyFactory = this._getCacheKeyFactory(type);
        assert (keyFactory != null);
        Object key = keyFactory.getCacheKey(context, request.getRenderProperties(context));
        if (key == null) {
            this._error(_CACHE_KEY_ERROR + type);
        }
        return key;
    }

    private CacheKeyFactory _getCacheKeyFactory(ImageType type) throws CacheException {
        CacheKeyFactory keyFactory = (CacheKeyFactory)type.getProperty(CacheKeyFactory.CACHE_KEY_FACTORY_PROPERTY);
        if (keyFactory == null) {
            this._error(_CACHE_KEY_FACTORY_ERROR + type);
        }
        return keyFactory;
    }

    private static String _getCanonicalPath(String path) {
        String canonicalPath = _sCanonicalPaths.get(path);
        if (canonicalPath != null) {
            return canonicalPath;
        }
        File file = new File(path);
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(_CACHE_PATH_ERROR + path);
        }
        if (canonicalPath != null) {
            _sCanonicalPaths.put(path, canonicalPath);
        }
        return canonicalPath;
    }

    private String _getFileName(ImageContext context, ImageType type, Map<Object, Object> properties) throws CacheException {
        String name;
        NameProvider nameProvider = (NameProvider)type.getProperty(NameProvider.NAME_PROVIDER_PROPERTY);
        if (nameProvider == null) {
            this._error(_NAME_PROVIDER_ERROR + type);
        }
        if ((name = nameProvider.getName(context, properties)) == null) {
            this._error(_NAME_PROVIDING_ERROR + type);
        }
        return name;
    }

    private Map<Object, Object> _getFilteredProperties(ImageContext context, ImageType type, ImageProviderRequest request) {
        PropertiesFilter filter;
        Map<Object, Object> properties = request.getRenderProperties(context);
        if (properties == null) {
            return null;
        }
        if (properties.get(ENCODING_TYPE_KEY) == null) {
            String encoding = this._getImageEncoding(context, properties);
            properties.put(ENCODING_TYPE_KEY, encoding);
        }
        if ((filter = (PropertiesFilter)type.getProperty(PropertiesFilter.PROPERTIES_FILTER_PROPERTY)) != null) {
            return filter.filterProperties(context, properties);
        }
        return properties;
    }

    private ImageEncoder _getImageEncoder(ImageContext context, Map<Object, Object> properties) throws CacheException {
        String encoding = this._getImageEncoding(context, properties);
        assert (encoding != null);
        ImageEncoderManager manager = ImageEncoderManager.getDefaultImageEncoderManager();
        ImageEncoder encoder = manager.getImageEncoder(encoding);
        if (encoder == null) {
            this._error(_IMAGE_ENCODER_ERROR + encoding);
        }
        return encoder;
    }

    private String _getImageEncoding(ImageContext context, Map<Object, Object> properties) {
        String encoding = (String)properties.get(ENCODING_TYPE_KEY);
        if (encoding != null) {
            return encoding;
        }
        Configuration config = context.getConfiguration();
        TrinidadAgent agent = context.getAgent();
        if (agent.getCapability(TrinidadAgent.CAP_GIF_TYPE_IMAGE) == Boolean.TRUE && !Boolean.FALSE.equals(config.getProperty(_GIF_ENABLED))) {
            return "image/gif";
        }
        if (agent.getCapability(TrinidadAgent.CAP_PNG_TYPE_IMAGE) == Boolean.TRUE) {
            return "image/png";
        }
        assert (false);
        return "image/png";
    }

    private String _getImageEncodingExtension(ImageContext context, Map<Object, Object> properties) throws CacheException {
        String encoding = this._getImageEncoding(context, properties);
        assert (encoding != null);
        ImageEncoderManager manager = ImageEncoderManager.getDefaultImageEncoderManager();
        String extension = manager.getImageExtension(encoding);
        if (extension == null) {
            this._error(_IMAGE_ENCODING_EXTENSION_ERROR + encoding);
        }
        return extension;
    }

    private ImageRenderer _getImageRenderer(ImageType type) throws CacheException {
        ImageRenderer renderer = (ImageRenderer)type.getProperty(ImageType.IMAGE_RENDERER_PROPERTY);
        if (renderer == null) {
            this._error(_IMAGE_RENDERER_ERROR + type);
        }
        return renderer;
    }

    private ImageType _getImageType(ImageContext context, ImageProviderRequest request) throws CacheException {
        String namespace = request.getNamespaceURI();
        String name = request.getLocalName();
        ImageTypeManager manager = CacheUtils.getImageTypeManager(context);
        assert (manager != null);
        ImageType type = manager.getImageType(namespace, name);
        if (type == null) {
            this._error(_IMAGE_TYPE_ERROR + namespace + ", " + name);
        }
        return type;
    }

    private int _getIntSize(Map<Object, Object> properties, Object key) {
        Integer value = (Integer)properties.get(key);
        if (value == null) {
            return -1;
        }
        return value;
    }

    private String _getLocaleString(ImageContext context) {
        Locale locale = context.getLocaleContext().getTranslationLocale();
        String language = locale.getLanguage();
        if (!_CHINESE_LANGUAGE.equals(language)) {
            return language;
        }
        return FileSystemImageCache._isSimplifiedChinese(locale.getCountry()) ? _SIMPLIFIED_CHINESE_DIRECTORY : _TRADITIONAL_CHINESE_DIRECTORY;
    }

    private String _getRealPath(String uri) {
        int length = this._realPath.length() + uri.length() + 1;
        StringBuffer buffer = new StringBuffer(length);
        buffer.append(this._realPath);
        buffer.append(File.separatorChar);
        buffer.append(uri);
        return buffer.toString();
    }

    private String _getRealPath(ImageContext context, ImageType type, String name, String extension) {
        boolean localized = this._isTypeLocalized(type);
        String language = this._getLocaleString(context);
        assert (language != null);
        int length = this._realPath.length() + name.length() + 1;
        if (localized) {
            length += language.length() + 1;
        }
        if (extension != null) {
            length += extension.length();
        }
        StringBuffer buffer = new StringBuffer(length + 1);
        buffer.append(this._realPath);
        buffer.append(File.separatorChar);
        if (localized) {
            buffer.append(language);
            buffer.append(File.separatorChar);
        }
        buffer.append(name);
        if (extension != null) {
            buffer.append(extension);
        }
        return buffer.toString();
    }

    private Reader _getUTF8Reader(InputStream in) throws CacheException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in, _UTF8));
        }
        catch (UnsupportedEncodingException e) {
            this._error(e);
        }
        assert (reader != null);
        return reader;
    }

    private XMLProvider _getXMLProvider(ImageContext context) throws CacheException {
        Configuration config = context.getConfiguration();
        XMLProvider parser = XMLUtils.getXMLProvider(config);
        if (parser == null) {
            this._error(_XML_PROVIDER_ERROR);
        }
        return parser;
    }

    private boolean _imageExists(String uri) {
        String path = this._getRealPath(uri);
        File file = new File(path);
        return file.exists();
    }

    private static boolean _isSimplifiedChinese(String region) {
        return "CN".equals(region);
    }

    private boolean _isTypeLocalized(ImageType type) {
        Object localized = type.getProperty(ImageType.LOCALIZED_PROPERTY);
        return !Boolean.FALSE.equals(localized);
    }

    private byte[] _readColorizedIconData(ImageContext context, Map<Object, Object> properties, Map<Object, Object> responseProperties) throws CacheException {
        String encoding = this._getImageEncoding(context, properties);
        if (!"image/gif".equals(encoding)) {
            return null;
        }
        if (CacheUtils.getReadingDirection(context, properties) != 1) {
            return null;
        }
        Color darkColor = (Color)properties.get(DARK_COLOR_KEY);
        if (darkColor != null && (darkColor.getRGB() & 0xFFFFFF) != 0x336699) {
            return null;
        }
        Color darkAccentColor = (Color)properties.get(DARK_ACCENT_COLOR_KEY);
        if (darkAccentColor != null && (darkAccentColor.getRGB() & 0xFFFFFF) != 13818032) {
            return null;
        }
        InputStreamProvider provider = (InputStreamProvider)properties.get(SOURCE_INPUT_STREAM_PROVIDER_KEY);
        if (provider != null) {
            byte[] data = null;
            try {
                data = this._readSourceIconData(provider);
            }
            catch (IOException e) {
                this._error(e);
            }
            if (data != null && data[0] == 71 && data[1] == 73 && data[2] == 70) {
                int width = data[6] | data[7] << 8;
                int height = data[8] | data[9] << 8;
                responseProperties.put(WIDTH_RESPONSE_KEY, width);
                responseProperties.put(HEIGHT_RESPONSE_KEY, height);
                return data;
            }
        }
        return null;
    }

    private static class IMXFilter
    implements FilenameFilter {
        private static IMXFilter _sInstance;

        private IMXFilter() {
        }

        public static FilenameFilter getInstance() {
            if (_sInstance == null) {
                _sInstance = new IMXFilter();
            }
            return _sInstance;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(FileSystemImageCache.__IMX_EXTENSION);
        }
    }
}

