/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testng;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testng.TestNGExecutor;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.testng.xml.Parser;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.xml.sax.SAXException;

public class TestNGXmlTestSuite
implements SurefireTestSuite {
    private File suiteFile;
    private String testSourceDirectory;
    private XmlSuite suite;
    private Map testSets;

    public TestNGXmlTestSuite(File suiteFile, String testSourceDirectory) {
        this.suiteFile = suiteFile;
        this.testSourceDirectory = testSourceDirectory;
    }

    public TestNGXmlTestSuite(File suiteFile) {
        this(suiteFile, null);
    }

    public void execute(ReporterManager reporterManager, ClassLoader classLoader) {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        TestNGExecutor.executeTestNG(this, this.testSourceDirectory, this.suite, reporterManager);
    }

    public void execute(String testSetName, ReporterManager reporterManager, ClassLoader classLoader) throws TestSetFailedException {
        if (this.testSets == null) {
            throw new IllegalStateException("You must call locateTestSets before calling execute");
        }
        XmlTest testSet = (XmlTest)this.testSets.get(testSetName);
        if (testSet == null) {
            throw new TestSetFailedException("Unable to find test set '" + testSetName + "' in suite");
        }
        ArrayList originalTests = new ArrayList(this.suite.getTests());
        Iterator i = this.suite.getTests().iterator();
        while (i.hasNext()) {
            XmlTest test = (XmlTest)i.next();
            if (test.getName().equals(testSetName)) continue;
            i.remove();
        }
        TestNGExecutor.executeTestNG(this, this.testSourceDirectory, this.suite, reporterManager);
        this.suite.getTests().clear();
        this.suite.getTests().addAll(originalTests);
    }

    public int getNumTests() {
        return 1;
    }

    public int getNumTestSets() {
        return this.suite.getTests().size();
    }

    public Map locateTestSets(ClassLoader classLoader) throws TestSetFailedException {
        if (this.testSets != null) {
            throw new IllegalStateException("You can't call locateTestSets twice");
        }
        this.testSets = new LinkedHashMap();
        try {
            this.suite = new Parser(this.suiteFile.getAbsolutePath()).parse();
        }
        catch (IOException e) {
            throw new TestSetFailedException("Error reading test suite", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new TestSetFailedException("Error reading test suite", (Throwable)e);
        }
        catch (SAXException e) {
            throw new TestSetFailedException("Error reading test suite", (Throwable)e);
        }
        Iterator i = this.suite.getTests().iterator();
        while (i.hasNext()) {
            XmlTest xmlTest = (XmlTest)i.next();
            if (this.testSets.containsKey(xmlTest.getName())) {
                throw new TestSetFailedException("Duplicate test set '" + xmlTest.getName() + "'");
            }
            this.testSets.put(xmlTest.getName(), xmlTest);
        }
        return this.testSets;
    }
}

