/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.surefire.junitcore.pc.Destroyable;
import org.apache.maven.surefire.junitcore.pc.Scheduler;
import org.apache.maven.surefire.report.ConsoleLogger;

public abstract class SchedulingStrategy
implements Destroyable {
    private final AtomicBoolean canSchedule = new AtomicBoolean(true);
    private final ConsoleLogger logger;

    protected SchedulingStrategy(ConsoleLogger logger) {
        this.logger = logger;
    }

    protected abstract void schedule(Runnable var1);

    protected abstract boolean finished() throws InterruptedException;

    protected abstract boolean stop();

    protected boolean stopNow() {
        return this.stop();
    }

    protected boolean disable() {
        return this.canSchedule.getAndSet(false);
    }

    protected void setDefaultShutdownHandler(Scheduler.ShutdownHandler handler) {
    }

    protected abstract boolean hasSharedThreadPool();

    protected boolean canSchedule() {
        return this.canSchedule.get();
    }

    protected void logQuietly(Throwable t) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(out);
        t.printStackTrace(stream);
        stream.close();
        this.logger.info(out.toString());
    }
}

