/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.junit.runner.Computer;
import org.junit.runner.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParallelComputer
extends Computer {
    private final long timeoutNanos;
    private final long timeoutForcedNanos;
    private ScheduledExecutorService shutdownScheduler;
    private Future<Collection<Description>> testsBeforeShutdown;
    private Future<Collection<Description>> testsBeforeForcedShutdown;

    public ParallelComputer(double timeoutInSeconds, double timeoutForcedInSeconds) {
        this.timeoutNanos = ParallelComputer.secondsToNanos(timeoutInSeconds);
        this.timeoutForcedNanos = ParallelComputer.secondsToNanos(timeoutForcedInSeconds);
    }

    private static long secondsToNanos(double seconds) {
        double nanos = seconds > 0.0 ? seconds * 1.0E9 : 0.0;
        return Double.isInfinite(nanos) || nanos >= 9.223372036854776E18 ? 0L : (long)nanos;
    }

    private static long minTimeout(long timeout1, long timeout2) {
        if (timeout1 == 0L) {
            return timeout2;
        }
        if (timeout2 == 0L) {
            return timeout1;
        }
        return Math.min(timeout1, timeout2);
    }

    private static Collection<String> printShutdownHook(Future<Collection<Description>> future) throws TestSetFailedException {
        if (!future.isCancelled() && future.isDone()) {
            try {
                TreeSet<String> executedTests = new TreeSet<String>();
                for (Description executedTest : future.get()) {
                    if (executedTest == null || executedTest.getDisplayName() == null) continue;
                    executedTests.add(executedTest.getDisplayName());
                }
                return executedTests;
            }
            catch (Exception e) {
                throw new TestSetFailedException((Throwable)e);
            }
        }
        return Collections.emptySet();
    }

    public abstract Collection<Description> shutdown(boolean var1);

    protected final void beforeRunQuietly() {
        this.testsBeforeShutdown = this.timeoutNanos > 0L ? this.scheduleShutdown() : null;
        this.testsBeforeForcedShutdown = this.timeoutForcedNanos > 0L ? this.scheduleForcedShutdown() : null;
    }

    protected final void afterRunQuietly() {
        if (this.shutdownScheduler != null) {
            this.shutdownScheduler.shutdownNow();
        }
    }

    public String describeElapsedTimeout() throws TestSetFailedException {
        TreeSet<String> executedTests = new TreeSet<String>();
        if (this.testsBeforeShutdown != null) {
            executedTests.addAll(ParallelComputer.printShutdownHook(this.testsBeforeShutdown));
        }
        if (this.testsBeforeForcedShutdown != null) {
            executedTests.addAll(ParallelComputer.printShutdownHook(this.testsBeforeForcedShutdown));
        }
        StringBuilder msg = new StringBuilder();
        if (!executedTests.isEmpty()) {
            msg.append("The test run has finished abruptly after timeout of ");
            msg.append(this.nanosToSeconds(ParallelComputer.minTimeout(this.timeoutNanos, this.timeoutForcedNanos)));
            msg.append(" seconds.\n");
            msg.append("These tests were executed in prior of the shutdown operation:\n");
            for (String executedTest : executedTests) {
                msg.append(executedTest).append('\n');
            }
        }
        return msg.toString();
    }

    private Future<Collection<Description>> scheduleShutdown() {
        return this.getShutdownScheduler().schedule(this.createShutdownTask(false), this.timeoutNanos, TimeUnit.NANOSECONDS);
    }

    private Future<Collection<Description>> scheduleForcedShutdown() {
        return this.getShutdownScheduler().schedule(this.createShutdownTask(true), this.timeoutForcedNanos, TimeUnit.NANOSECONDS);
    }

    private ScheduledExecutorService getShutdownScheduler() {
        if (this.shutdownScheduler == null) {
            this.shutdownScheduler = Executors.newScheduledThreadPool(2);
        }
        return this.shutdownScheduler;
    }

    private Callable<Collection<Description>> createShutdownTask(final boolean isForced) {
        return new Callable<Collection<Description>>(){

            @Override
            public Collection<Description> call() throws Exception {
                return ParallelComputer.this.shutdown(isForced);
            }
        };
    }

    private double nanosToSeconds(long nanos) {
        return (double)nanos / 1.0E9;
    }
}

