/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit4;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.common.junit4.JUnit4RunListener;
import org.apache.maven.surefire.common.junit4.JUnit4RunListenerFactory;
import org.apache.maven.surefire.common.junit4.JUnit4TestChecker;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.shade.org.codehaus.plexus.util.SelectorUtils;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.DefaultDirectoryScanner;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.RunOrderCalculator;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.apache.maven.surefire.util.internal.StringUtils;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4Provider
extends AbstractProvider {
    private final ClassLoader testClassLoader;
    private final DirectoryScanner directoryScanner;
    private final List<RunListener> customRunListeners;
    private final JUnit4TestChecker jUnit4TestChecker;
    private final String requestedTestMethod;
    private TestsToRun testsToRun;
    private final ProviderParameters providerParameters;
    private final RunOrderCalculator runOrderCalculator;

    public JUnit4Provider(ProviderParameters booterParameters) {
        this.providerParameters = booterParameters;
        this.testClassLoader = booterParameters.getTestClassLoader();
        this.directoryScanner = booterParameters.getDirectoryScanner();
        this.runOrderCalculator = booterParameters.getRunOrderCalculator();
        this.customRunListeners = JUnit4RunListenerFactory.createCustomListeners(booterParameters.getProviderProperties().getProperty("listener"));
        this.jUnit4TestChecker = new JUnit4TestChecker(this.testClassLoader);
        this.requestedTestMethod = booterParameters.getTestRequest().getRequestedTestMethod();
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException {
        if (this.testsToRun == null) {
            this.testsToRun = forkTestSet == null ? this.scanClassPath() : TestsToRun.fromClass((Class)((Class)forkTestSet));
        }
        this.upgradeCheck();
        ReporterFactory reporterFactory = this.providerParameters.getReporterFactory();
        org.apache.maven.surefire.report.RunListener reporter = reporterFactory.createReporter();
        ConsoleOutputCapture.startCapture((ConsoleOutputReceiver)((ConsoleOutputReceiver)reporter));
        JUnit4RunListener jUnit4TestSetReporter = new JUnit4RunListener(reporter);
        Result result = new Result();
        RunNotifier runNotifer = this.getRunNotifer(jUnit4TestSetReporter, result, this.customRunListeners);
        runNotifer.fireTestRunStarted(null);
        for (Class clazz : this.testsToRun.getLocatedClasses()) {
            this.executeTestSet(clazz, reporter, runNotifer);
        }
        runNotifer.fireTestRunFinished(result);
        JUnit4RunListener.rethrowAnyTestMechanismFailures(result);
        this.closeRunNotifer(jUnit4TestSetReporter, this.customRunListeners);
        return reporterFactory.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTestSet(Class<?> clazz, org.apache.maven.surefire.report.RunListener reporter, RunNotifier listeners) throws ReporterException, TestSetFailedException {
        SimpleReportEntry report = new SimpleReportEntry(((Object)((Object)this)).getClass().getName(), clazz.getName());
        reporter.testSetStarting((ReportEntry)report);
        try {
            if (!StringUtils.isBlank((String)this.requestedTestMethod)) {
                String actualTestMethod = JUnit4Provider.getMethod(clazz, this.requestedTestMethod);
                String[] testMethods = StringUtils.split((String)actualTestMethod, (String)"+");
                JUnit4Provider.execute(clazz, listeners, testMethods);
            } else {
                JUnit4Provider.execute(clazz, listeners, null);
            }
        }
        catch (TestSetFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            reporter.testError((ReportEntry)new SimpleReportEntry(report.getSourceName(), report.getName(), (StackTraceWriter)new PojoStackTraceWriter(report.getSourceName(), report.getName(), e)));
        }
        finally {
            reporter.testSetCompleted((ReportEntry)report);
        }
    }

    private RunNotifier getRunNotifer(RunListener main, Result result, List<RunListener> others) {
        RunNotifier fNotifier = new RunNotifier();
        fNotifier.addListener(main);
        fNotifier.addListener(result.createListener());
        for (RunListener listener : others) {
            fNotifier.addListener(listener);
        }
        return fNotifier;
    }

    private void closeRunNotifer(RunListener main, List<RunListener> others) {
        RunNotifier fNotifier = new RunNotifier();
        fNotifier.removeListener(main);
        for (RunListener listener : others) {
            fNotifier.removeListener(listener);
        }
    }

    public Iterator<?> getSuites() {
        this.testsToRun = this.scanClassPath();
        return this.testsToRun.iterator();
    }

    private TestsToRun scanClassPath() {
        TestsToRun scannedClasses = this.directoryScanner.locateTestClasses(this.testClassLoader, (ScannerFilter)this.jUnit4TestChecker);
        return this.runOrderCalculator.orderTestClasses(scannedClasses);
    }

    private void upgradeCheck() throws TestSetFailedException {
        if (this.isJunit4UpgradeCheck() && ((DefaultDirectoryScanner)this.directoryScanner).getClassesSkippedByValidation().size() > 0) {
            StringBuilder reason = new StringBuilder();
            reason.append("Updated check failed\n");
            reason.append("There are tests that would be run with junit4 / surefire 2.6 but not with [2.7,):\n");
            for (Class testClass : ((DefaultDirectoryScanner)this.directoryScanner).getClassesSkippedByValidation()) {
                reason.append("   ");
                reason.append(testClass.getCanonicalName());
                reason.append("\n");
            }
            throw new TestSetFailedException(reason.toString());
        }
    }

    private boolean isJunit4UpgradeCheck() {
        String property = System.getProperty("surefire.junit4.upgradecheck");
        return property != null;
    }

    private static void execute(Class<?> testClass, RunNotifier fNotifier, String[] testMethods) throws TestSetFailedException {
        if (null != testMethods) {
            Method[] methods = testClass.getMethods();
            int size = methods.length;
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < testMethods.length; ++j) {
                    if (!SelectorUtils.match(testMethods[j], methods[i].getName())) continue;
                    Runner junitTestRunner = Request.method(testClass, (String)methods[i].getName()).getRunner();
                    junitTestRunner.run(fNotifier);
                }
            }
            return;
        }
        Runner junitTestRunner = Request.aClass(testClass).getRunner();
        junitTestRunner.run(fNotifier);
    }

    private static String getMethod(Class testClass, String testMethodStr) {
        int endIndex;
        int beginIndex;
        String className = testClass.getName();
        if (testMethodStr.indexOf("#") < 0 && testMethodStr.indexOf(",") < 0) {
            return testMethodStr;
        }
        String classMethodStr = (testMethodStr = testMethodStr + ",").substring(beginIndex = testMethodStr.indexOf(className), endIndex = testMethodStr.indexOf(",", beginIndex));
        int index = classMethodStr.indexOf(35);
        if (index >= 0) {
            return classMethodStr.substring(index + 1, classMethodStr.length());
        }
        return null;
    }
}

