/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.maven.surefire.booter.BaseProviderFactory;
import org.apache.maven.surefire.booter.BooterDeserializer;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ForkingRunListener;
import org.apache.maven.surefire.booter.LazyTestsToRun;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SurefireReflector;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.LegacyPojoStackTraceWriter;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.ReflectionUtils;

public class ForkedBooter {
    private static final long SYSTEM_EXIT_TIMEOUT = 30000L;

    public static void main(String[] args) throws Throwable {
        PrintStream originalOut = System.out;
        try {
            File surefirePropertiesFile;
            if (args.length > 1) {
                SystemPropertyManager.setSystemProperties(new File(args[1]));
            }
            FileInputStream stream = (surefirePropertiesFile = new File(args[0])).exists() ? new FileInputStream(surefirePropertiesFile) : null;
            BooterDeserializer booterDeserializer = new BooterDeserializer(stream);
            ProviderConfiguration providerConfiguration = booterDeserializer.deserialize();
            StartupConfiguration startupConfiguration = booterDeserializer.getProviderConfiguration();
            TypeEncodedValue forkedTestSet = providerConfiguration.getTestForFork();
            boolean readTestsFromInputStream = providerConfiguration.isReadTestsFromInStream();
            ClasspathConfiguration classpathConfiguration = startupConfiguration.getClasspathConfiguration();
            if (startupConfiguration.isManifestOnlyJarRequestedAndUsable()) {
                classpathConfiguration.trickClassPathWhenManifestOnlyClasspath();
            }
            Thread.currentThread().getContextClassLoader().setDefaultAssertionStatus(classpathConfiguration.isEnableAssertions());
            startupConfiguration.writeSurefireTestClasspathProperty();
            Object testSet = forkedTestSet != null ? forkedTestSet.getDecodedValue(Thread.currentThread().getContextClassLoader()) : (readTestsFromInputStream ? new LazyTestsToRun(System.in, originalOut) : null);
            try {
                ForkedBooter.runSuitesInProcess(testSet, startupConfiguration, providerConfiguration, originalOut);
            }
            catch (InvocationTargetException t) {
                LegacyPojoStackTraceWriter stackTraceWriter = new LegacyPojoStackTraceWriter("test subystem", "no method", t.getTargetException());
                StringBuffer stringBuffer = new StringBuffer();
                ForkingRunListener.encode((StringBuffer)stringBuffer, (StackTraceWriter)stackTraceWriter, (boolean)false);
                originalOut.println("X,0," + stringBuffer.toString());
            }
            catch (Throwable t) {
                LegacyPojoStackTraceWriter stackTraceWriter = new LegacyPojoStackTraceWriter("test subystem", "no method", t);
                StringBuffer stringBuffer = new StringBuffer();
                ForkingRunListener.encode((StringBuffer)stringBuffer, (StackTraceWriter)stackTraceWriter, (boolean)false);
                originalOut.println("X,0," + stringBuffer.toString());
            }
            originalOut.println("Z,0,BYE!");
            originalOut.flush();
            ForkedBooter.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            ForkedBooter.exit(1);
        }
    }

    private static void exit(int returnCode) {
        ForkedBooter.launchLastDitchDaemonShutdownThread(returnCode);
        System.exit(returnCode);
    }

    private static RunResult runSuitesInProcess(Object testSet, StartupConfiguration startupConfiguration, ProviderConfiguration providerConfiguration, PrintStream originalSystemOut) throws SurefireExecutionException, TestSetFailedException, InvocationTargetException {
        ReporterFactory factory = ForkedBooter.createForkingReporterFactory(providerConfiguration, originalSystemOut);
        return ForkedBooter.invokeProviderInSameClassLoader(testSet, factory, providerConfiguration, true, startupConfiguration, false);
    }

    private static ReporterFactory createForkingReporterFactory(ProviderConfiguration providerConfiguration, PrintStream originalSystemOut) {
        Boolean trimStackTrace = providerConfiguration.getReporterConfiguration().isTrimStackTrace();
        return SurefireReflector.createForkingReporterFactoryInCurrentClassLoader((Boolean)trimStackTrace, (PrintStream)originalSystemOut);
    }

    private static void launchLastDitchDaemonShutdownThread(final int returnCode) {
        Thread lastExit = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(30000L);
                    Runtime.getRuntime().halt(returnCode);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        lastExit.setDaemon(true);
        lastExit.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RunResult invokeProviderInSameClassLoader(Object testSet, Object factory, ProviderConfiguration providerConfiguration, boolean insideFork, StartupConfiguration startupConfiguration1, boolean restoreStreams) throws TestSetFailedException, InvocationTargetException {
        PrintStream orgSystemOut = System.out;
        PrintStream orgSystemErr = System.err;
        SurefireProvider provider = ForkedBooter.createProviderInCurrentClassloader(startupConfiguration1, insideFork, providerConfiguration, factory);
        try {
            RunResult runResult = provider.invoke(testSet);
            return runResult;
        }
        finally {
            if (restoreStreams && System.getSecurityManager() == null) {
                System.setOut(orgSystemOut);
                System.setErr(orgSystemErr);
            }
        }
    }

    public static SurefireProvider createProviderInCurrentClassloader(StartupConfiguration startupConfiguration1, boolean isInsideFork, ProviderConfiguration providerConfiguration, Object reporterManagerFactory1) {
        BaseProviderFactory bpf = new BaseProviderFactory((ReporterFactory)reporterManagerFactory1, Boolean.valueOf(isInsideFork));
        bpf.setTestRequest(providerConfiguration.getTestSuiteDefinition());
        bpf.setReporterConfiguration(providerConfiguration.getReporterConfiguration());
        ClassLoader clasLoader = Thread.currentThread().getContextClassLoader();
        bpf.setClassLoaders(clasLoader);
        bpf.setTestArtifactInfo(providerConfiguration.getTestArtifact());
        bpf.setProviderProperties(providerConfiguration.getProviderProperties());
        bpf.setRunOrderParameters(providerConfiguration.getRunOrderParameters());
        bpf.setDirectoryScannerParameters(providerConfiguration.getDirScannerParams());
        return (SurefireProvider)ReflectionUtils.instantiateOneArg((ClassLoader)clasLoader, (String)startupConfiguration1.getActualClassName(), ProviderParameters.class, (Object)bpf);
    }
}

