/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.File;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReportWriter;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.StackTraceWriter;

public abstract class AbstractReporter
implements Reporter,
ReportWriter {
    int completedCount;
    int errors;
    int failures;
    private long startTime;
    private long endTime;
    private final NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
    static final String NL = System.getProperty("line.separator");
    private static final int MS_PER_SEC = 1000;
    long testSetStartTime;
    int skipped;
    private final boolean trimStackTrace;
    private final ReporterConfiguration reporterConfiguration;

    AbstractReporter(ReporterConfiguration reporterConfiguration) {
        this.reporterConfiguration = reporterConfiguration;
        this.trimStackTrace = reporterConfiguration.isTrimStackTrace();
    }

    boolean isTimedOut() {
        return this.reporterConfiguration.isTimedOut();
    }

    public void writeFooter(String footer) {
        this.writeMessage(footer);
    }

    public void runStarting() {
    }

    public void runCompleted() {
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        this.testSetStartTime = System.currentTimeMillis();
    }

    public void testSetCompleted(ReportEntry report) throws ReporterException {
    }

    public void testStarting(ReportEntry report) {
        this.startTime = System.currentTimeMillis();
    }

    public void testSucceeded(ReportEntry report) {
        this.endTest();
    }

    public void testSkipped(ReportEntry report) {
        ++this.skipped;
        this.endTest();
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
        ++this.errors;
        this.endTest();
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
        ++this.failures;
        this.endTest();
    }

    private void endTest() {
        ++this.completedCount;
        this.endTime = System.currentTimeMillis();
        if (this.startTime == 0L) {
            this.startTime = this.endTime;
        }
    }

    int getNumErrors() {
        return this.errors;
    }

    int getNumSkipped() {
        return this.skipped;
    }

    int getNumFailures() {
        return this.failures;
    }

    int getNumTests() {
        return this.completedCount;
    }

    public void reset() {
        this.errors = 0;
        this.skipped = 0;
        this.failures = 0;
        this.completedCount = 0;
    }

    String elapsedTimeAsString(long runTime) {
        return this.numberFormat.format((double)runTime / 1000.0);
    }

    String getStackTrace(ReportEntry report) {
        StackTraceWriter writer = report.getStackTraceWriter();
        if (writer == null) {
            return null;
        }
        return this.trimStackTrace ? writer.writeTrimmedTraceToString() : writer.writeTraceToString();
    }

    long getActualRunTime(ReportEntry reportEntry) {
        Integer clientSpecifiedElapsed = reportEntry.getElapsed();
        return clientSpecifiedElapsed != null ? (long)clientSpecifiedElapsed.intValue() : this.endTime - this.startTime;
    }

    public void testError(ReportEntry report) {
    }

    public void testFailed(ReportEntry report) {
    }

    public void testAssumptionFailure(ReportEntry report) {
    }

    void deleteIfExisting(File reportFile) {
        if (reportFile.exists()) {
            reportFile.delete();
        }
    }
}

