/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.BufferedOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.maven.surefire.report.AbstractTextReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;

public abstract class AbstractConsoleReporter
extends AbstractTextReporter {
    private static final String TEST_SET_STARTING_PREFIX = "Running ";
    private static final String TEST_SET_STARTING_GROUP_PREFIX = " (of ";
    private static final String TEST_SET_STARTING_GROUP_SUFIX = ")";
    protected static final int BUFFER_SIZE = 4096;

    protected AbstractConsoleReporter(String format, Boolean trimStackTrace) {
        super(new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(System.out, 4096))), format, trimStackTrace);
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        super.testSetStarting(report);
        this.writeMessage(AbstractConsoleReporter.getTestSetStartingMessage(report));
    }

    public void runStarting(int testCount) {
        this.writeHeading("");
        this.writeHeading("-------------------------------------------------------");
        this.writeHeading(" T E S T S");
        this.writeHeading("-------------------------------------------------------");
    }

    public void writeHeading(String message) {
        this.writer.println(message);
        this.writer.flush();
    }

    public void runAborted(ReportEntry report) {
        this.printAbortionError("RUN ABORTED", report);
    }

    public void testSetAborted(ReportEntry report) {
        this.printAbortionError("TEST SET ABORTED", report);
    }

    private void printAbortionError(String msg, ReportEntry report) {
        this.writer.println(msg);
        this.writer.println(report.getSource().getClass().getName());
        this.writer.println(report.getName());
        this.writer.println(report.getMessage());
        this.writer.println(this.getStackTrace(report));
        this.writer.flush();
    }

    public static String getTestSetStartingMessage(ReportEntry report) {
        StringBuffer message = new StringBuffer();
        message.append(TEST_SET_STARTING_PREFIX);
        message.append(report.getName());
        if (report.getGroup() != null && !report.getName().equals(report.getGroup())) {
            message.append(TEST_SET_STARTING_GROUP_PREFIX);
            message.append(report.getGroup());
            message.append(TEST_SET_STARTING_GROUP_SUFIX);
        }
        return message.toString();
    }

    public static ReportEntry parseTestSetStartingMessage(String message) {
        ReportEntry reportEntry = new ReportEntry();
        int i = message.indexOf(TEST_SET_STARTING_GROUP_PREFIX);
        if (i >= 0) {
            int j = message.indexOf(TEST_SET_STARTING_GROUP_SUFIX);
            if (j <= 0) {
                throw new RuntimeException("Message provided can not be parsed");
            }
            reportEntry.setGroup(message.substring(i + TEST_SET_STARTING_GROUP_PREFIX.length(), j));
        } else {
            i = message.length();
            if (i <= 0) {
                throw new RuntimeException("Message provided can not be parsed");
            }
        }
        reportEntry.setName(message.substring(TEST_SET_STARTING_PREFIX.length(), i));
        return reportEntry;
    }

    public static boolean isTestSetStartingMessage(String message) {
        return message.startsWith(TEST_SET_STARTING_PREFIX);
    }
}

