/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testset.TestSetFailedException;

public class Surefire {
    private static final int SUCCESS = 0;
    private static final int NO_TESTS = 254;
    private static final int FAILURE = 255;
    private ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    public static final String SUREFIRE_BUNDLE_NAME = "org.apache.maven.surefire.surefire";
    static /* synthetic */ Class class$java$lang$String;

    public boolean run(List reportDefinitions, Object[] testSuiteDefinition, String testSetName, ClassLoader surefireClassLoader, ClassLoader testsClassLoader) throws ReporterException, TestSetFailedException {
        return this.run(reportDefinitions, testSuiteDefinition, testSetName, surefireClassLoader, testsClassLoader, null, Boolean.FALSE) == 0;
    }

    public int run(List reportDefinitions, Object[] testSuiteDefinition, String testSetName, ClassLoader surefireClassLoader, ClassLoader testsClassLoader, Boolean failIfNoTests) throws ReporterException, TestSetFailedException {
        return this.run(reportDefinitions, testSuiteDefinition, testSetName, surefireClassLoader, testsClassLoader, null, failIfNoTests);
    }

    public boolean run(List reportDefinitions, Object[] testSuiteDefinition, String testSetName, ClassLoader surefireClassLoader, ClassLoader testsClassLoader, Properties results) throws ReporterException, TestSetFailedException {
        return this.run(reportDefinitions, testSuiteDefinition, testSetName, surefireClassLoader, testsClassLoader, results, Boolean.FALSE) == 0;
    }

    public int run(List reportDefinitions, Object[] testSuiteDefinition, String testSetName, ClassLoader surefireClassLoader, ClassLoader testsClassLoader, Properties results, Boolean failIfNoTests) throws ReporterException, TestSetFailedException {
        ReporterManager reporterManager = new ReporterManager(this.instantiateReports(reportDefinitions, surefireClassLoader));
        if (results != null) {
            reporterManager.initResultsFromProperties(results);
        }
        int totalTests = 0;
        SurefireTestSuite suite = this.createSuiteFromDefinition(testSuiteDefinition, surefireClassLoader, testsClassLoader);
        int testCount = suite.getNumTests();
        if (testCount > 0) {
            totalTests += testCount;
        }
        reporterManager.runStarting(totalTests);
        if (totalTests == 0) {
            reporterManager.writeMessage("There are no tests to run.");
        } else {
            suite.execute(testSetName, reporterManager, testsClassLoader);
        }
        reporterManager.runCompleted();
        if (results != null) {
            reporterManager.updateResultsProperties(results);
        }
        if (failIfNoTests.booleanValue() && reporterManager.getNbTests() == 0) {
            return 254;
        }
        if (reporterManager.getNumErrors() == 0 && reporterManager.getNumFailures() == 0) {
            return 0;
        }
        return 255;
    }

    public boolean run(List reportDefinitions, List testSuiteDefinitions, ClassLoader surefireClassLoader, ClassLoader testsClassLoader) throws ReporterException, TestSetFailedException {
        return this.run(reportDefinitions, testSuiteDefinitions, surefireClassLoader, testsClassLoader, Boolean.FALSE) == 0;
    }

    public int run(List reportDefinitions, List testSuiteDefinitions, ClassLoader surefireClassLoader, ClassLoader testsClassLoader, Boolean failIfNoTests) throws ReporterException, TestSetFailedException {
        ReporterManager reporterManager = new ReporterManager(this.instantiateReports(reportDefinitions, surefireClassLoader));
        ArrayList<SurefireTestSuite> suites = new ArrayList<SurefireTestSuite>();
        int totalTests = 0;
        Iterator i = testSuiteDefinitions.iterator();
        while (i.hasNext()) {
            Object[] definition = (Object[])i.next();
            SurefireTestSuite suite = this.createSuiteFromDefinition(definition, surefireClassLoader, testsClassLoader);
            int testCount = suite.getNumTests();
            if (testCount <= 0) continue;
            suites.add(suite);
            totalTests += testCount;
        }
        reporterManager.runStarting(totalTests);
        if (totalTests == 0) {
            reporterManager.writeMessage("There are no tests to run.");
        } else {
            i = suites.iterator();
            while (i.hasNext()) {
                SurefireTestSuite suite = (SurefireTestSuite)i.next();
                suite.execute(reporterManager, testsClassLoader);
            }
        }
        reporterManager.runCompleted();
        if (failIfNoTests.booleanValue() && reporterManager.getNbTests() == 0) {
            return 254;
        }
        if (reporterManager.getNumErrors() == 0 && reporterManager.getNumFailures() == 0) {
            return 0;
        }
        return 255;
    }

    private SurefireTestSuite createSuiteFromDefinition(Object[] definition, ClassLoader surefireClassLoader, ClassLoader testsClassLoader) throws TestSetFailedException {
        String suiteClass = (String)definition[0];
        Object[] params = (Object[])definition[1];
        SurefireTestSuite suite = Surefire.instantiateSuite(suiteClass, params, surefireClassLoader);
        suite.locateTestSets(testsClassLoader);
        return suite;
    }

    private List instantiateReports(List reportDefinitions, ClassLoader classLoader) throws TestSetFailedException {
        ArrayList<Reporter> reports = new ArrayList<Reporter>();
        Iterator i = reportDefinitions.iterator();
        while (i.hasNext()) {
            Object[] definition = (Object[])i.next();
            String className = (String)definition[0];
            Object[] params = (Object[])definition[1];
            Reporter report = Surefire.instantiateReport(className, params, classLoader);
            reports.add(report);
        }
        return reports;
    }

    private static Reporter instantiateReport(String className, Object[] params, ClassLoader classLoader) throws TestSetFailedException {
        try {
            return (Reporter)Surefire.instantiateObject(className, params, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new TestSetFailedException("Unable to find class to create report '" + className + "'", e);
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException("Unable to find appropriate constructor to create report: " + e.getMessage(), e);
        }
    }

    public static Object instantiateObject(String className, Object[] params, ClassLoader classLoader) throws TestSetFailedException, ClassNotFoundException, NoSuchMethodException {
        Object object;
        Class<?> clazz = classLoader.loadClass(className);
        try {
            if (params != null) {
                Class[] paramTypes = new Class[params.length];
                for (int j = 0; j < params.length; ++j) {
                    paramTypes[j] = params[j] == null ? (class$java$lang$String == null ? Surefire.class$("java.lang.String") : class$java$lang$String) : params[j].getClass();
                }
                Constructor<?> constructor = clazz.getConstructor(paramTypes);
                object = constructor.newInstance(params);
            } else {
                object = clazz.newInstance();
            }
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException("Unable to instantiate object: " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new TestSetFailedException(e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (InstantiationException e) {
            throw new TestSetFailedException("Unable to instantiate object: " + e.getMessage(), e);
        }
        return object;
    }

    private static SurefireTestSuite instantiateSuite(String suiteClass, Object[] params, ClassLoader classLoader) throws TestSetFailedException {
        try {
            return (SurefireTestSuite)Surefire.instantiateObject(suiteClass, params, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new TestSetFailedException("Unable to find class to create suite '" + suiteClass + "'", e);
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException("Unable to find appropriate constructor to create suite: " + e.getMessage(), e);
        }
    }

    public String getResourceString(String key) {
        return this.bundle.getString(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

