/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.maven.plugin.surefire.report.FileReporterUtils;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.util.internal.StringUtils;

public class FileReporter {
    private final File reportsDirectory;
    private final String reportNameSuffix;

    public FileReporter(File reportsDirectory, String reportNameSuffix) {
        this.reportsDirectory = reportsDirectory;
        this.reportNameSuffix = reportNameSuffix;
    }

    private PrintWriter testSetStarting(ReportEntry report) {
        File reportFile = FileReporter.getReportFile(this.reportsDirectory, report.getName(), this.reportNameSuffix, ".txt");
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(reportFile));
            writer.println("-------------------------------------------------------------------------------");
            writer.println("Test set: " + report.getName());
            writer.println("-------------------------------------------------------------------------------");
            return writer;
        }
        catch (IOException e) {
            throw new ReporterException("Unable to create file for report: " + e.getMessage(), (Exception)e);
        }
    }

    public static File getReportFile(File reportsDirectory, String reportEntryName, String reportNameSuffix, String fileExtension) {
        String fileName = reportEntryName + (StringUtils.isNotBlank((String)reportNameSuffix) ? "-" + reportNameSuffix : "") + fileExtension;
        return new File(reportsDirectory, FileReporterUtils.stripIllegalFilenameChars(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetCompleted(WrappedReportEntry report, TestSetStats testSetStats, List<String> testResults) {
        PrintWriter writer = this.testSetStarting(report);
        try {
            writer.println(testSetStats.getTestSetSummary(report));
            for (String testResult : testResults) {
                writer.println(testResult);
            }
            writer.flush();
        }
        finally {
            writer.close();
        }
    }
}

