/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.SmartStackTraceParser;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.util.internal.StringUtils;

public class PojoStackTraceWriter
implements StackTraceWriter {
    private final Throwable t;
    private final String testClass;
    private final String testMethod;

    public PojoStackTraceWriter(String testClass, String testMethod, Throwable t) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.t = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String writeTraceToString() {
        if (this.t != null) {
            String exc;
            StringWriter w = new StringWriter();
            PrintWriter stackTrace = new PrintWriter(w);
            try {
                this.t.printStackTrace(stackTrace);
                stackTrace.flush();
            }
            finally {
                stackTrace.close();
            }
            StringBuffer builder = w.getBuffer();
            if (PojoStackTraceWriter.isMultiLineExceptionMessage(this.t) && StringUtils.startsWith(builder, exc = this.t.getClass().getName() + ": ")) {
                builder.insert(exc.length(), '\n');
            }
            return builder.toString();
        }
        return "";
    }

    @Override
    public String smartTrimmedStackTrace() {
        return this.t == null ? "" : new SmartStackTraceParser(this.testClass, this.t, this.testMethod).getString();
    }

    @Override
    public String writeTrimmedTraceToString() {
        return this.t == null ? "" : SmartStackTraceParser.stackTraceWithFocusOnClassAsString(this.t, this.testClass);
    }

    @Override
    public SafeThrowable getThrowable() {
        return this.t == null ? null : new SafeThrowable(this.t);
    }

    private static boolean isMultiLineExceptionMessage(Throwable t) {
        String msg = t.getLocalizedMessage();
        if (msg != null) {
            int countNewLines = 0;
            int length = msg.length();
            for (int i = 0; i < length && (msg.charAt(i) != '\n' || ++countNewLines != 2); ++i) {
            }
            return countNewLines > 1 || countNewLines == 1 && !msg.trim().endsWith("\n");
        }
        return false;
    }
}

