/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.local.metadata;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.local.metadata.LocalScmMetadata;
import org.apache.maven.scm.provider.local.metadata.io.xpp3.LocalScmMetadataXpp3Reader;
import org.apache.maven.scm.provider.local.metadata.io.xpp3.LocalScmMetadataXpp3Writer;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class LocalScmMetadataUtils {
    public static final String FILENMAE = ".maven-scm-local";
    protected final ScmLogger logger;

    public LocalScmMetadataUtils(ScmLogger logger) {
        this.logger = logger;
    }

    public LocalScmMetadata buildMetadata(File repository) throws IOException {
        List repoFilenames = FileUtils.getFileNames((File)repository.getAbsoluteFile(), (String)"**", null, (boolean)false);
        LocalScmMetadata metadata = new LocalScmMetadata();
        metadata.setRepositoryFileNames(repoFilenames);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMetadata(File destinationDir, LocalScmMetadata metadata) throws IOException {
        File metadataFile = new File(destinationDir, FILENMAE);
        metadataFile.createNewFile();
        FileWriter writer = new FileWriter(metadataFile);
        try {
            new LocalScmMetadataXpp3Writer().write(writer, metadata);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public LocalScmMetadata readMetadata(File dir) {
        File metadataFile = new File(dir, FILENMAE);
        if (!metadataFile.exists()) {
            return null;
        }
        LocalScmMetadata result = null;
        FileReader reader = null;
        try {
            reader = new FileReader(metadataFile);
            result = new LocalScmMetadataXpp3Reader().read(reader);
        }
        catch (XmlPullParserException e) {
            this.logger.warn("Could not interpret .maven-scm-local - ignoring", (Throwable)e);
            LocalScmMetadata localScmMetadata = null;
            IOUtil.close((Reader)reader);
            return localScmMetadata;
        }
        catch (IOException e2) {
            this.logger.warn("Could not Read .maven-scm-local - ignoring", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
            }
            IOUtil.close((Reader)reader);
        }
        IOUtil.close((Reader)reader);
        return result;
    }
}

