/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.checkin;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.add.GitAddCommand;
import org.apache.maven.scm.provider.git.gitexe.command.branch.GitBranchCommand;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusCommand;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.apache.maven.scm.provider.git.util.GitUtil;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitCheckInCommand
extends AbstractCheckInCommand
implements GitCommand {
    private final Map<String, String> environmentVariables;

    public GitCheckInCommand(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, ScmVersion version) throws ScmException {
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        int exitCode = -1;
        File messageFile = FileUtils.createTempFile((String)"maven-scm-", (String)".commit", null);
        try {
            FileUtils.fileWrite((String)messageFile.getAbsolutePath(), (String)"UTF-8", (String)message);
        }
        catch (IOException ex) {
            return new CheckInScmResult(null, "Error while making a temporary file for the commit message: " + ex.getMessage(), null, false);
        }
        try {
            Commandline cl;
            GitStatusConsumer statusConsumer;
            if (!fileSet.getFileList().isEmpty()) {
                Commandline clAdd = null;
                if (Os.isFamily((String)"windows")) {
                    for (File file : fileSet.getFileList()) {
                        clAdd = GitAddCommand.createCommandLine(fileSet.getBasedir(), Collections.singletonList(file));
                        exitCode = GitCommandLineUtils.execute(clAdd, stdout, stderr);
                        if (exitCode == 0) continue;
                        break;
                    }
                } else {
                    clAdd = GitAddCommand.createCommandLine(fileSet.getBasedir(), fileSet.getFileList());
                    exitCode = GitCommandLineUtils.execute(clAdd, stdout, stderr);
                }
                if (exitCode != 0) {
                    CheckInScmResult checkInScmResult = new CheckInScmResult(clAdd.toString(), "The git-add command failed.", stderr.getOutput(), false);
                    return checkInScmResult;
                }
            }
            URI relativeRepositoryPath = GitStatusCommand.getRelativeCWD(this.logger, fileSet);
            Commandline clStatus = GitStatusCommand.createCommandLine(repository, fileSet);
            exitCode = GitCommandLineUtils.execute(clStatus, (StreamConsumer)(statusConsumer = new GitStatusConsumer(fileSet.getBasedir(), relativeRepositoryPath, fileSet)), stderr);
            if (exitCode != 0 && this.logger.isInfoEnabled()) {
                this.logger.info("nothing added to commit but untracked files present (use \"git add\" to track)");
            }
            if (statusConsumer.getChangedFiles().isEmpty()) {
                CheckInScmResult checkInScmResult = new CheckInScmResult(null, statusConsumer.getChangedFiles());
                return checkInScmResult;
            }
            Commandline clCommit = GitCheckInCommand.createCommitCommandLine(repository, fileSet, messageFile, this.environmentVariables);
            exitCode = GitCommandLineUtils.execute(clCommit, stdout, stderr);
            if (exitCode != 0) {
                CheckInScmResult checkInScmResult = new CheckInScmResult(clCommit.toString(), "The git-commit command failed.", stderr.getOutput(), false);
                return checkInScmResult;
            }
            if (repo.isPushChanges() && (exitCode = GitCommandLineUtils.execute(cl = this.createPushCommandLine(repository, fileSet, version), stdout, stderr)) != 0) {
                CheckInScmResult checkInScmResult = new CheckInScmResult(cl.toString(), "The git-push command failed.", stderr.getOutput(), false);
                return checkInScmResult;
            }
            ArrayList<ScmFile> checkedInFiles = new ArrayList<ScmFile>(statusConsumer.getChangedFiles().size());
            for (ScmFile changedFile : statusConsumer.getChangedFiles()) {
                ScmFile scmfile = new ScmFile(changedFile.getPath(), ScmFileStatus.CHECKED_IN);
                if (fileSet.getFileList().isEmpty()) {
                    checkedInFiles.add(scmfile);
                    continue;
                }
                for (File f : fileSet.getFileList()) {
                    if (!FilenameUtils.separatorsToUnix((String)f.getPath()).equals(scmfile.getPath())) continue;
                    checkedInFiles.add(scmfile);
                }
            }
            CheckInScmResult checkInScmResult = new CheckInScmResult(clCommit.toString(), checkedInFiles);
            return checkInScmResult;
        }
        finally {
            try {
                FileUtils.forceDelete((File)messageFile);
            }
            catch (IOException file) {}
        }
    }

    public Commandline createPushCommandLine(GitScmProviderRepository repository, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "push", repository, this.environmentVariables);
        String branch = GitBranchCommand.getCurrentBranch(repository, fileSet);
        if (branch == null || branch.length() == 0) {
            throw new ScmException("Could not detect the current branch. Don't know where I should push to!");
        }
        cl.createArg().setValue(repository.getPushUrl());
        cl.createArg().setValue("refs/heads/" + branch + ":refs/heads/" + branch);
        return cl;
    }

    public static Commandline createCommitCommandLine(GitScmProviderRepository repository, ScmFileSet fileSet, File messageFile) throws ScmException {
        return GitCheckInCommand.createCommitCommandLine(repository, fileSet, messageFile, Collections.emptyMap());
    }

    public static Commandline createCommitCommandLine(GitScmProviderRepository repository, ScmFileSet fileSet, File messageFile, Map<String, String> environmentVariables) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(fileSet.getBasedir(), "commit");
        cl.createArg().setValue("--verbose");
        cl.createArg().setValue("-F");
        cl.createArg().setValue(messageFile.getAbsolutePath());
        if (fileSet.getFileList().isEmpty()) {
            cl.createArg().setValue("-a");
        }
        if (GitUtil.getSettings().isCommitNoVerify()) {
            cl.createArg().setValue("--no-verify");
        }
        return cl;
    }
}

