/*
 * $Id$
 */

package org.apache.maven.scm.providers.cvslib.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class Settings.
 * 
 * @version $Revision$ $Date$
 */
public class Settings implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *              Date format allowed by changelog command.
     *           
     */
    private String changeLogCommandDateFormat = "yyyy-MM-dd HH:mm:ssZ";

    /**
     * 
     *              Do you want to use .cvsrc file?
     *           
     */
    private boolean useCvsrc = false;

    /**
     * 
     *              Sets the compression level on communications
     * with the server? If you don't want to use compression, set
     * it to 0.
     *           
     */
    private int compressionLevel = 3;

    /**
     * 
     *              Traces the execution of a CVS command.
     *           
     */
    private boolean traceCvsCommand = false;

    /**
     * 
     *              Stores any temporary files in DIR instead of
     * wherever CVS normally puts them (specifically, this
     * overrides the value of the $TMPDIR environment variable, if
     * any exists). It should be an absolute path.
     *           
     */
    private String temporaryFilesDirectory;

    /**
     * Field cvsVariables.
     */
    private java.util.Properties cvsVariables;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addCvsVariable.
     * 
     * @param key
     * @param value
     */
    public void addCvsVariable(String key, String value)
    {
        getCvsVariables().put( key, value );
    } //-- void addCvsVariable(String, String) 

    /**
     * Get 
     *              Date format allowed by changelog command.
     *           
     * 
     * @return String
     */
    public String getChangeLogCommandDateFormat()
    {
        return this.changeLogCommandDateFormat;
    } //-- String getChangeLogCommandDateFormat() 

    /**
     * Get 
     *              Sets the compression level on communications
     * with the server? If you don't want to use compression, set
     * it to 0.
     *           
     * 
     * @return int
     */
    public int getCompressionLevel()
    {
        return this.compressionLevel;
    } //-- int getCompressionLevel() 

    /**
     * Method getCvsVariables.
     * 
     * @return java.util.Properties
     */
    public java.util.Properties getCvsVariables()
    {
        if ( this.cvsVariables == null )
        {
            this.cvsVariables = new java.util.Properties();
        }
        
        return this.cvsVariables;
    } //-- java.util.Properties getCvsVariables() 

    /**
     * Get 
     *              Stores any temporary files in DIR instead of
     * wherever CVS normally puts them (specifically, this
     * overrides the value of the $TMPDIR environment variable, if
     * any exists). It should be an absolute path.
     *           
     * 
     * @return String
     */
    public String getTemporaryFilesDirectory()
    {
        return this.temporaryFilesDirectory;
    } //-- String getTemporaryFilesDirectory() 

    /**
     * Get 
     *              Traces the execution of a CVS command.
     *           
     * 
     * @return boolean
     */
    public boolean isTraceCvsCommand()
    {
        return this.traceCvsCommand;
    } //-- boolean isTraceCvsCommand() 

    /**
     * Get 
     *              Do you want to use .cvsrc file?
     *           
     * 
     * @return boolean
     */
    public boolean isUseCvsrc()
    {
        return this.useCvsrc;
    } //-- boolean isUseCvsrc() 

    /**
     * Set 
     *              Date format allowed by changelog command.
     *           
     * 
     * @param changeLogCommandDateFormat
     */
    public void setChangeLogCommandDateFormat(String changeLogCommandDateFormat)
    {
        this.changeLogCommandDateFormat = changeLogCommandDateFormat;
    } //-- void setChangeLogCommandDateFormat(String) 

    /**
     * Set 
     *              Sets the compression level on communications
     * with the server? If you don't want to use compression, set
     * it to 0.
     *           
     * 
     * @param compressionLevel
     */
    public void setCompressionLevel(int compressionLevel)
    {
        this.compressionLevel = compressionLevel;
    } //-- void setCompressionLevel(int) 

    /**
     * Set 
     *              This sets internal CVS variables
     *           .
     * 
     * @param cvsVariables
     */
    public void setCvsVariables(java.util.Properties cvsVariables)
    {
        this.cvsVariables = cvsVariables;
    } //-- void setCvsVariables(java.util.Properties) 

    /**
     * Set 
     *              Stores any temporary files in DIR instead of
     * wherever CVS normally puts them (specifically, this
     * overrides the value of the $TMPDIR environment variable, if
     * any exists). It should be an absolute path.
     *           
     * 
     * @param temporaryFilesDirectory
     */
    public void setTemporaryFilesDirectory(String temporaryFilesDirectory)
    {
        this.temporaryFilesDirectory = temporaryFilesDirectory;
    } //-- void setTemporaryFilesDirectory(String) 

    /**
     * Set 
     *              Traces the execution of a CVS command.
     *           
     * 
     * @param traceCvsCommand
     */
    public void setTraceCvsCommand(boolean traceCvsCommand)
    {
        this.traceCvsCommand = traceCvsCommand;
    } //-- void setTraceCvsCommand(boolean) 

    /**
     * Set 
     *              Do you want to use .cvsrc file?
     *           
     * 
     * @param useCvsrc
     */
    public void setUseCvsrc(boolean useCvsrc)
    {
        this.useCvsrc = useCvsrc;
    } //-- void setUseCvsrc(boolean) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
