/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractRewritePomsPhase;
import org.apache.maven.shared.release.scm.ScmTranslator;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class RewritePomsForBranchPhase
extends AbstractRewritePomsPhase {
    private Map scmTranslators;

    protected void transformScm(MavenProject project, Element rootElement, Namespace namespace, ReleaseDescriptor releaseDescriptor, String projectId, ScmRepository scmRepository, ReleaseResult result, MavenProject rootProject) {
        if (project.getScm() != null) {
            Element scmRoot = rootElement.getChild("scm", namespace);
            if (scmRoot != null) {
                releaseDescriptor.mapOriginalScmInfo(projectId, project.getScm());
                this.translateScm(project, releaseDescriptor, scmRoot, namespace, scmRepository, result, rootProject);
            } else {
                releaseDescriptor.mapOriginalScmInfo(projectId, null);
                MavenProject parent = project.getParent();
                if (parent != null) {
                    String parentId = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId());
                    if (!releaseDescriptor.getOriginalScmInfo().containsKey(parentId)) {
                        scmRoot = new Element("scm");
                        scmRoot.addContent("\n  ");
                        if (this.translateScm(project, releaseDescriptor, scmRoot, namespace, scmRepository, result, rootProject)) {
                            rootElement.addContent("\n  ").addContent((Content)scmRoot).addContent("\n");
                        }
                    }
                }
            }
        }
    }

    private boolean translateScm(MavenProject project, ReleaseDescriptor releaseDescriptor, Element scmRoot, Namespace namespace, ScmRepository scmRepository, ReleaseResult relResult, MavenProject rootProject) {
        ScmTranslator translator = (ScmTranslator)this.scmTranslators.get(scmRepository.getProvider());
        boolean result = false;
        if (translator != null) {
            String value;
            Scm scm = project.getScm();
            String branchName = releaseDescriptor.getScmReleaseLabel();
            String branchBase = releaseDescriptor.getScmTagBase();
            String subDirectoryBranch = "";
            if (branchBase != null) {
                branchBase = "scm:svn:" + branchBase;
            }
            Scm rootScm = rootProject.getScm();
            if (scm.getConnection() != null) {
                if (rootScm.getConnection() != null && scm.getConnection().indexOf(rootScm.getConnection()) == 0) {
                    subDirectoryBranch = scm.getConnection().substring(rootScm.getConnection().length());
                }
                if (!(value = translator.translateBranchUrl(scm.getConnection(), branchName + subDirectoryBranch, branchBase)).equals(scm.getConnection())) {
                    this.rewriteElement("connection", value, scmRoot, namespace);
                    result = true;
                }
            }
            if (scm.getDeveloperConnection() != null) {
                if (rootScm.getDeveloperConnection() != null && scm.getDeveloperConnection().indexOf(rootScm.getDeveloperConnection()) == 0) {
                    subDirectoryBranch = scm.getDeveloperConnection().substring(rootScm.getDeveloperConnection().length());
                }
                if (!(value = translator.translateBranchUrl(scm.getDeveloperConnection(), branchName + subDirectoryBranch, branchBase)).equals(scm.getDeveloperConnection())) {
                    this.rewriteElement("developerConnection", value, scmRoot, namespace);
                    result = true;
                }
            }
            if (scm.getUrl() != null) {
                if (rootScm.getUrl() != null && scm.getUrl().indexOf(rootScm.getUrl()) == 0) {
                    subDirectoryBranch = scm.getUrl().substring(rootScm.getUrl().length());
                }
                if (!(value = translator.translateBranchUrl(scm.getUrl(), branchName + subDirectoryBranch, releaseDescriptor.getScmTagBase())).equals(scm.getUrl())) {
                    this.rewriteElement("url", value, scmRoot, namespace);
                    result = true;
                }
            }
            if (branchName != null && (value = translator.resolveTag(branchName)) != null && !value.equals(scm.getTag())) {
                this.rewriteElement("tag", value, scmRoot, namespace);
                result = true;
            }
        } else {
            String message = "No SCM translator found - skipping rewrite";
            relResult.appendDebug(message);
            this.getLogger().debug(message);
        }
        return result;
    }

    protected Map getOriginalVersionMap(ReleaseDescriptor releaseDescriptor, List reactorProjects) {
        return releaseDescriptor.getOriginalVersions(reactorProjects);
    }

    protected Map getNextVersionMap(ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getReleaseVersions();
    }

    protected String getResolvedSnapshotVersion(String artifactVersionlessKey, Map resolvedSnapshotsMap) {
        Map versionsMap = (Map)resolvedSnapshotsMap.get(artifactVersionlessKey);
        if (versionsMap != null) {
            return (String)versionsMap.get("rel");
        }
        return null;
    }
}

