/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.List;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class InputVariablesPhase
extends AbstractReleasePhase {
    private Prompter prompter;
    private ScmRepositoryConfigurator scmRepositoryConfigurator;

    void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    protected ScmProvider getScmProvider(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment) throws ReleaseScmRepositoryException, ReleaseExecutionException {
        try {
            ScmRepository repository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, releaseEnvironment.getSettings());
            return this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage() + " for URL: " + releaseDescriptor.getScmSourceUrl(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
    }

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        MavenProject project = ReleaseUtil.getRootProject(reactorProjects);
        String tag = releaseDescriptor.getScmReleaseLabel();
        if (tag == null) {
            String key = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
            String releaseVersion = (String)releaseDescriptor.getReleaseVersions().get(key);
            if (releaseVersion == null) {
                throw new ReleaseExecutionException("Project tag cannot be selected if version is not yet mapped");
            }
            String defaultTag = project.getArtifactId() + "-" + releaseVersion;
            ScmProvider provider = null;
            try {
                provider = this.getScmProvider(releaseDescriptor, releaseEnvironment);
            }
            catch (ReleaseScmRepositoryException e) {
                throw new ReleaseExecutionException("No scm provider can be found for url: " + releaseDescriptor.getScmSourceUrl(), e);
            }
            defaultTag = provider.sanitizeTagName(defaultTag);
            if (releaseDescriptor.isInteractive()) {
                try {
                    tag = this.prompter.prompt("What is SCM release tag or label for \"" + project.getName() + "\"? (" + project.getGroupId() + ":" + project.getArtifactId() + ")", defaultTag);
                }
                catch (PrompterException e) {
                    throw new ReleaseExecutionException("Error reading version from input handler: " + e.getMessage(), e);
                }
            } else {
                tag = defaultTag;
            }
            releaseDescriptor.setScmReleaseLabel(tag);
        }
        result.setResultCode(0);
        return result;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List reactorProjects) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        this.execute(releaseDescriptor, releaseEnvironment, reactorProjects);
        result.setResultCode(0);
        return result;
    }
}

